*#**********************************************************************

      DOUBLE PRECISION FUNCTION DZNRM2( N, ZX, INCX)                    00000010
      LOGICAL IMAG, SCALE                                               00000020
      INTEGER          NEXT                                             00000030
      DOUBLE PRECISION CUTLO, CUTHI, HITEST, SUM, XMAX, ABSX, ZERO, ONE 00000040
      COMPLEX*16      ZX(1)                                             00000050
      DOUBLE PRECISION DREAL,DIMAG                                      00000060
      COMPLEX*16 ZDUMR,ZDUMI                                            00000070
      DREAL(ZDUMR) = ZDUMR                                              00000080
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00000090
      DATA         ZERO, ONE /0.0D0, 1.0D0/                             00000100
C                                                                       00000110
C     UNITARY NORM OF THE COMPLEX N-VECTOR STORED IN ZX() WITH STORAGE  00000120
C     INCREMENT INCX .                                                  00000130
C     IF    N .LE. 0 RETURN WITH RESULT = 0.                            00000140
C     IF N .GE. 1 THEN INCX MUST BE .GE. 1                              00000150
C                                                                       00000160
C           C.L.LAWSON , 1978 JAN 08                                    00000170
C                                                                       00000180
C     FOUR PHASE METHOD     USING TWO BUILT-IN CONSTANTS THAT ARE       00000190
C     HOPEFULLY APPLICABLE TO ALL MACHINES.                             00000200
C         CUTLO = MAXIMUM OF  SQRT(U/EPS)  OVER ALL KNOWN MACHINES.     00000210
C         CUTHI = MINIMUM OF  SQRT(V)      OVER ALL KNOWN MACHINES.     00000220
C     WHERE                                                             00000230
C         EPS = SMALLEST NO. SUCH THAT EPS + 1. .GT. 1.                 00000240
C         U   = SMALLEST POSITIVE NO.   (UNDERFLOW LIMIT)               00000250
C         V   = LARGEST  NO.            (OVERFLOW  LIMIT)               00000260
C                                                                       00000270
C     BRIEF OUTLINE OF ALGORITHM..                                      00000280
C                                                                       00000290
C     PHASE 1    SCANS ZERO COMPONENTS.                                 00000300
C     MOVE TO PHASE 2 WHEN A COMPONENT IS NONZERO AND .LE. CUTLO        00000310
C     MOVE TO PHASE 3 WHEN A COMPONENT IS .GT. CUTLO                    00000320
C     MOVE TO PHASE 4 WHEN A COMPONENT IS .GE. CUTHI/M                  00000330
C     WHERE M = N FOR X() REAL AND M = 2*N FOR COMPLEX.                 00000340
C                                                                       00000350
C     VALUES FOR CUTLO AND CUTHI..                                      00000360
C     FROM THE ENVIRONMENTAL PARAMETERS LISTED IN THE IMSL CONVERTER    00000370
C     DOCUMENT THE LIMITING VALUES ARE AS FOLLOWS..                     00000380
C     CUTLO, S.P.   U/EPS = 2**(-102) FOR  HONEYWELL.  CLOSE SECONDS ARE00000390
C                   UNIVAC AND DEC AT 2**(-103)                         00000400
C                   THUS CUTLO = 2**(-51) = 4.44089E-16                 00000410
C     CUTHI, S.P.   V = 2**127 FOR UNIVAC, HONEYWELL, AND DEC.          00000420
C                   THUS CUTHI = 2**(63.5) = 1.30438E19                 00000430
C     CUTLO, D.P.   U/EPS = 2**(-67) FOR HONEYWELL AND DEC.             00000440
C                   THUS CUTLO = 2**(-33.5) = 8.23181D-11               00000450
C     CUTHI, D.P.   SAME AS S.P.  CUTHI = 1.30438D19                    00000460
C     DATA CUTLO, CUTHI / 8.232D-11,  1.304D19 /                        00000470
C     DATA CUTLO, CUTHI / 4.441E-16,  1.304E19 /                        00000480
      DATA CUTLO, CUTHI / 8.232D-11,  1.304D19 /                        00000490
C                                                                       00000500
      IF(N .GT. 0) GO TO 10                                             00000510
         DZNRM2  = ZERO                                                 00000520
         GO TO 300                                                      00000530
C                                                                       00000540
   10 ASSIGN 30 TO NEXT                                                 00000550
      SUM = ZERO                                                        00000560
      NN = N * INCX                                                     00000570
C                                                 BEGIN MAIN LOOP       00000580
      DO 210 I=1,NN,INCX                                                00000590
         ABSX = DABS(DREAL(ZX(I)))                                      00000600
         IMAG = .FALSE.                                                 00000610
         GO TO NEXT,(30, 50, 70, 90, 110)                               00000620
   30 IF( ABSX .GT. CUTLO) GO TO 85                                     00000630
      ASSIGN 50 TO NEXT                                                 00000640
      SCALE = .FALSE.                                                   00000650
C                                                                       00000660
C                        PHASE 1.  SUM IS ZERO                          00000670
C                                                                       00000680
   50 IF( ABSX .EQ. ZERO) GO TO 200                                     00000690
      IF( ABSX .GT. CUTLO) GO TO 85                                     00000700
C                                                                       00000710
C                                PREPARE FOR PHASE 2.                   00000720
      ASSIGN 70 TO NEXT                                                 00000730
      GO TO 105                                                         00000740
C                                                                       00000750
C                                PREPARE FOR PHASE 4.                   00000760
C                                                                       00000770
  100 ASSIGN 110 TO NEXT                                                00000780
      SUM = (SUM / ABSX) / ABSX                                         00000790
  105 SCALE = .TRUE.                                                    00000800
      XMAX = ABSX                                                       00000810
      GO TO 115                                                         00000820
C                                                                       00000830
C                   PHASE 2.  SUM IS SMALL.                             00000840
C                             SCALE TO AVOID DESTRUCTIVE UNDERFLOW.     00000850
C                                                                       00000860
   70 IF( ABSX .GT. CUTLO ) GO TO 75                                    00000870
C                                                                       00000880
C                     COMMON CODE FOR PHASES 2 AND 4.                   00000890
C                     IN PHASE 4 SUM IS LARGE.  SCALE TO AVOID OVERFLOW.00000900
C                                                                       00000910
  110 IF( ABSX .LE. XMAX ) GO TO 115                                    00000920
         SUM = ONE + SUM * (XMAX / ABSX)**2                             00000930
         XMAX = ABSX                                                    00000940
         GO TO 200                                                      00000950
C                                                                       00000960
  115 SUM = SUM + (ABSX/XMAX)**2                                        00000970
      GO TO 200                                                         00000980
C                                                                       00000990
C                                                                       00001000
C                  PREPARE FOR PHASE 3.                                 00001010
C                                                                       00001020
   75 SUM = (SUM * XMAX) * XMAX                                         00001030
C                                                                       00001040
   85 ASSIGN 90 TO NEXT                                                 00001050
      SCALE = .FALSE.                                                   00001060
C                                                                       00001070
C     FOR REAL OR D.P. SET HITEST = CUTHI/N                             00001080
C     FOR COMPLEX      SET HITEST = CUTHI/(2*N)                         00001090
C                                                                       00001100
      HITEST = CUTHI/FLOAT( N )                                         00001110
C                                                                       00001120
C                   PHASE 3.  SUM IS MID-RANGE.  NO SCALING.            00001130
C                                                                       00001140
   90 IF(ABSX .GE. HITEST) GO TO 100                                    00001150
         SUM = SUM + ABSX**2                                            00001160
  200 CONTINUE                                                          00001170
C                  CONTROL SELECTION OF REAL AND IMAGINARY PARTS.       00001180
C                                                                       00001190
      IF(IMAG) GO TO 210                                                00001200
         ABSX = DABS(DIMAG(ZX(I)))                                      00001210
         IMAG = .TRUE.                                                  00001220
      GO TO NEXT,(  50, 70, 90, 110 )                                   00001230
C                                                                       00001240
  210 CONTINUE                                                          00001250
C                                                                       00001260
C              END OF MAIN LOOP.                                        00001270
C              COMPUTE SQUARE ROOT AND ADJUST FOR SCALING.              00001280
C                                                                       00001290
      DZNRM2 = DSQRT(SUM)                                               00001300
      IF(SCALE) DZNRM2 = DZNRM2 * XMAX                                  00001310
  300 CONTINUE                                                          00001320
      RETURN                                                            00001330
      END                                                               00001340
