*#**********************************************************************

      REAL FUNCTION SASUM(N,SX,INCX)                                    00000010
C                                                                       00000020
C     TAKES THE SUM OF THE ABSOLUTE VALUES.                             00000030
C     USES UNROLLED LOOPS FOR INCREMENT EQUAL TO ONE.                   00000040
C     JACK DONGARRA, LINPACK, 3/11/78.                                  00000050
C                                                                       00000060
      REAL SX(1),STEMP                                                  00000070
      INTEGER I,INCX,M,MP1,N,NINCX                                      00000080
C                                                                       00000090
      SASUM = 0.0E0                                                     00000100
      STEMP = 0.0E0                                                     00000110
      IF(N.LE.0)RETURN                                                  00000120
      IF(INCX.EQ.1)GO TO 20                                             00000130
C                                                                       00000140
C        CODE FOR INCREMENT NOT EQUAL TO 1                              00000150
C                                                                       00000160
      NINCX = N*INCX                                                    00000170
      DO 10 I = 1,NINCX,INCX                                            00000180
        STEMP = STEMP + ABS(SX(I))                                      00000190
   10 CONTINUE                                                          00000200
      SASUM = STEMP                                                     00000210
      RETURN                                                            00000220
C                                                                       00000230
C        CODE FOR INCREMENT EQUAL TO 1                                  00000240
C                                                                       00000250
C                                                                       00000260
C        CLEAN-UP LOOP                                                  00000270
C                                                                       00000280
   20 M = MOD(N,6)                                                      00000290
      IF( M .EQ. 0 ) GO TO 40                                           00000300
      DO 30 I = 1,M                                                     00000310
        STEMP = STEMP + ABS(SX(I))                                      00000320
   30 CONTINUE                                                          00000330
      IF( N .LT. 6 ) GO TO 60                                           00000340
   40 MP1 = M + 1                                                       00000350
      DO 50 I = MP1,N,6                                                 00000360
        STEMP = STEMP + ABS(SX(I)) + ABS(SX(I + 1)) + ABS(SX(I + 2))    00000370
     *  + ABS(SX(I + 3)) + ABS(SX(I + 4)) + ABS(SX(I + 5))              00000380
   50 CONTINUE                                                          00000390
   60 SASUM = STEMP                                                     00000400
      RETURN                                                            00000410
      END                                                               00000420
