*#**********************************************************************

      SUBROUTINE SQRSL(X,LDX,N,K,QRAUX,Y,QY,QTY,B,RSD,XB,JOB,INFO)      00000010

      INTEGER LDX,N,K,JOB,INFO                                          00000020
      REAL X(LDX,1),QRAUX(1),Y(1),QY(1),QTY(1),B(1),RSD(1),XB(1)        00000030
C                                                                       00000040
C     SQRSL APPLIES THE OUTPUT OF SQRDC TO COMPUTE COORDINATE           00000050
C     TRANSFORMATIONS, PROJECTIONS, AND LEAST SQUARES SOLUTIONS.        00000060
C     FOR K .LE. MIN(N,P), LET XK BE THE MATRIX                         00000070
C                                                                       00000080
C            XK = (X(JPVT(1)),X(JPVT(2)), ... ,X(JPVT(K)))              00000090
C                                                                       00000100
C     FORMED FROM COLUMNNS JPVT(1), ... ,JPVT(K) OF THE ORIGINAL        00000110
C     N X P MATRIX X THAT WAS INPUT TO SQRDC (IF NO PIVOTING WAS        00000120
C     DONE, XK CONSISTS OF THE FIRST K COLUMNS OF X IN THEIR            00000130
C     ORIGINAL ORDER).  SQRDC PRODUCES A FACTORED ORTHOGONAL MATRIX Q   00000140
C     AND AN UPPER TRIANGULAR MATRIX R SUCH THAT                        00000150
C                                                                       00000160
C              XK = Q * (R)                                             00000170
C                       (0)                                             00000180
C                                                                       00000190
C     THIS INFORMATION IS CONTAINED IN CODED FORM IN THE ARRAYS         00000200
C     X AND QRAUX.                                                      00000210
C                                                                       00000220
C     ON ENTRY                                                          00000230
C                                                                       00000240
C        X      REAL(LDX,P).                                            00000250
C               X CONTAINS THE OUTPUT OF SQRDC.                         00000260
C                                                                       00000270
C        LDX    INTEGER.                                                00000280
C               LDX IS THE LEADING DIMENSION OF THE ARRAY X.            00000290
C                                                                       00000300
C        N      INTEGER.                                                00000310
C               N IS THE NUMBER OF ROWS OF THE MATRIX XK.  IT MUST      00000320
C               HAVE THE SAME VALUE AS N IN SQRDC.                      00000330
C                                                                       00000340
C        K      INTEGER.                                                00000350
C               K IS THE NUMBER OF COLUMNS OF THE MATRIX XK.  K         00000360
C               MUST NNOT BE GREATER THAN MIN(N,P), WHERE P IS THE      00000370
C               SAME AS IN THE CALLING SEQUENCE TO SQRDC.               00000380
C                                                                       00000390
C        QRAUX  REAL(P).                                                00000400
C               QRAUX CONTAINS THE AUXILIARY OUTPUT FROM SQRDC.         00000410
C                                                                       00000420
C        Y      REAL(N)                                                 00000430
C               Y CONTAINS AN N-VECTOR THAT IS TO BE MANIPULATED        00000440
C               BY SQRSL.                                               00000450
C                                                                       00000460
C        JOB    INTEGER.                                                00000470
C               JOB SPECIFIES WHAT IS TO BE COMPUTED.  JOB HAS          00000480
C               THE DECIMAL EXPANSION ABCDE, WITH THE FOLLOWING         00000490
C               MEANING.                                                00000500
C                                                                       00000510
C                    IF A.NE.0, COMPUTE QY.                             00000520
C                    IF B,C,D, OR E .NE. 0, COMPUTE QTY.                00000530
C                    IF C.NE.0, COMPUTE B.                              00000540
C                    IF D.NE.0, COMPUTE RSD.                            00000550
C                    IF E.NE.0, COMPUTE XB.                             00000560
C                                                                       00000570
C               NOTE THAT A REQUEST TO COMPUTE B, RSD, OR XB            00000580
C               AUTOMATICALLY TRIGGERS THE COMPUTATION OF QTY, FOR      00000590
C               WHICH AN ARRAY MUST BE PROVIDED IN THE CALLING          00000600
C               SEQUENCE.                                               00000610
C                                                                       00000620
C     ON RETURN                                                         00000630
C                                                                       00000640
C        QY     REAL(N).                                                00000650
C               QY CONNTAINS Q*Y, IF ITS COMPUTATION HAS BEEN           00000660
C               REQUESTED.                                              00000670
C                                                                       00000680
C        QTY    REAL(N).                                                00000690
C               QTY CONTAINS TRANS(Q)*Y, IF ITS COMPUTATION HAS         00000700
C               BEEN REQUESTED.  HERE TRANS(Q) IS THE                   00000710
C               TRANSPOSE OF THE MATRIX Q.                              00000720
C                                                                       00000730
C        B      REAL(K)                                                 00000740
C               B CONTAINS THE SOLUTION OF THE LEAST SQUARES PROBLEM    00000750
C                                                                       00000760
C                    MINIMIZE NORM2(Y - XK*B),                          00000770
C                                                                       00000780
C               IF ITS COMPUTATION HAS BEEN REQUESTED.  (NOTE THAT      00000790
C               IF PIVOTING WAS REQUESTED IN SQRDC, THE J-TH            00000800
C               COMPONENT OF B WILL BE ASSOCIATED WITH COLUMN JPVT(J)   00000810
C               OF THE ORIGINAL MATRIX X THAT WAS INPUT INTO SQRDC.)    00000820
C                                                                       00000830
C        RSD    REAL(N).                                                00000840
C               RSD CONTAINS THE LEAST SQUARES RESIDUAL Y - XK*B,       00000850
C               IF ITS COMPUTATION HAS BEEN REQUESTED.  RSD IS          00000860
C               ALSO THE ORTHOGONAL PROJECTION OF Y ONTO THE            00000870
C               ORTHOGONAL COMPLEMENT OF THE COLUMN SPACE OF XK.        00000880
C                                                                       00000890
C        XB     REAL(N).                                                00000900
C               XB CONTAINS THE LEAST SQUARES APPROXIMATION XK*B,       00000910
C               IF ITS COMPUTATION HAS BEEN REQUESTED.  XB IS ALSO      00000920
C               THE ORTHOGONAL PROJECTION OF Y ONTO THE COLUMN SPACE    00000930
C               OF X.                                                   00000940
C                                                                       00000950
C        INFO   INTEGER.                                                00000960
C               INFO IS ZERO UNLESS THE COMPUTATION OF B HAS            00000970
C               BEEN REQUESTED AND R IS EXACTLY SINGULAR.  IN           00000980
C               THIS CASE, INFO IS THE INDEX OF THE FIRST ZERO          00000990
C               DIAGONAL ELEMENT OF R AND B IS LEFT UNALTERED.          00001000
C                                                                       00001010
C     THE PARAMETERS QY, QTY, B, RSD, AND XB ARE NOT REFERENCED         00001020
C     IF THEIR COMPUTATION IS NOT REQUESTED AND IN THIS CASE            00001030
C     CAN BE REPLACED BY DUMMY VARIABLES IN THE CALLING PROGRAM.        00001040
C     TO SAVE STORAGE, THE USER MAY IN SOME CASES USE THE SAME          00001050
C     ARRAY FOR DIFFERENT PARAMETERS IN THE CALLING SEQUENCE.  A        00001060
C     FREQUENTLY OCCURING EXAMPLE IS WHEN ONE WISHES TO COMPUTE         00001070
C     ANY OF B, RSD, OR XB AND DOES NOT NEED Y OR QTY.  IN THIS         00001080
C     CASE ONE MAY IDENTIFY Y, QTY, AND ONE OF B, RSD, OR XB, WHILE     00001090
C     PROVIDING SEPARATE ARRAYS FOR ANYTHING ELSE THAT IS TO BE         00001100
C     COMPUTED.  THUS THE CALLING SEQUENCE                              00001110
C                                                                       00001120
C          CALL SQRSL(X,LDX,N,K,QRAUX,Y,DUM,Y,B,Y,DUM,110,INFO)         00001130
C                                                                       00001140
C     WILL RESULT IN THE COMPUTATION OF B AND RSD, WITH RSD             00001150
C     OVERWRITING Y.  MORE GENERALLY, EACH ITEM IN THE FOLLOWING        00001160
C     LIST CONTAINS GROUPS OF PERMISSIBLE IDENTIFICATIONS FOR           00001170
C     A SINGLE CALLINNG SEQUENCE.                                       00001180
C                                                                       00001190
C          1. (Y,QTY,B) (RSD) (XB) (QY)                                 00001200
C                                                                       00001210
C          2. (Y,QTY,RSD) (B) (XB) (QY)                                 00001220
C                                                                       00001230
C          3. (Y,QTY,XB) (B) (RSD) (QY)                                 00001240
C                                                                       00001250
C          4. (Y,QY) (QTY,B) (RSD) (XB)                                 00001260
C                                                                       00001270
C          5. (Y,QY) (QTY,RSD) (B) (XB)                                 00001280
C                                                                       00001290
C          6. (Y,QY) (QTY,XB) (B) (RSD)                                 00001300
C                                                                       00001310
C     IN ANY GROUP THE VALUE RETURNED IN THE ARRAY ALLOCATED TO         00001320
C     THE GROUP CORRESPONDS TO THE LAST MEMBER OF THE GROUP.            00001330
C                                                                       00001340
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00001350
C     G.W. STEWART, UNIVERSITY OF MARYLAND, ARGONNE NATIONAL LAB.       00001360
C                                                                       00001370
C     SQRSL USES THE FOLLOWING FUNCTIONS AND SUBPROGRAMS.               00001380
C                                                                       00001390
C     BLAS SAXPY,SCOPY,SDOT                                             00001400
C     FORTRAN ABS,MIN0,MOD                                              00001410
C                                                                       00001420
C     INTERNAL VARIABLES                                                00001430
C                                                                       00001440
      INTEGER I,J,JJ,JU,KP1                                             00001450
      REAL SDOT,T,TEMP                                                  00001460
      LOGICAL CB,CQY,CQTY,CR,CXB                                        00001470
C                                                                       00001480
C                                                                       00001490
C     SET INFO FLAG.                                                    00001500
C                                                                       00001510
      INFO = 0                                                          00001520
C                                                                       00001530
C     DETERMINE WHAT IS TO BE COMPUTED.                                 00001540
C                                                                       00001550
      CQY = JOB/10000 .NE. 0                                            00001560
      CQTY = MOD(JOB,10000) .NE. 0                                      00001570
      CB = MOD(JOB,1000)/100 .NE. 0                                     00001580
      CR = MOD(JOB,100)/10 .NE. 0                                       00001590
      CXB = MOD(JOB,10) .NE. 0                                          00001600
      JU = MIN0(K,N-1)                                                  00001610
C                                                                       00001620
C     SPECIAL ACTION WHEN N=1.                                          00001630
C                                                                       00001640
      IF (JU .NE. 0) GO TO 40                                           00001650
         IF (CQY) QY(1) = Y(1)                                          00001660
         IF (CQTY) QTY(1) = Y(1)                                        00001670
         IF (CXB) XB(1) = Y(1)                                          00001680
         IF (.NOT.CB) GO TO 30                                          00001690
            IF (X(1,1) .NE. 0.0E0) GO TO 10                             00001700
               INFO = 1                                                 00001710
            GO TO 20                                                    00001720
   10       CONTINUE                                                    00001730
               B(1) = Y(1)/X(1,1)                                       00001740
   20       CONTINUE                                                    00001750
   30    CONTINUE                                                       00001760
         IF (CR) RSD(1) = 0.0E0                                         00001770
      GO TO 250                                                         00001780
   40 CONTINUE                                                          00001790
C                                                                       00001800
C        SET UP TO COMPUTE QY OR QTY.                                   00001810
C                                                                       00001820
         IF (CQY) CALL SCOPY(N,Y,1,QY,1)                                00001830
         IF (CQTY) CALL SCOPY(N,Y,1,QTY,1)                              00001840
         IF (.NOT.CQY) GO TO 70                                         00001850
C                                                                       00001860
C           COMPUTE QY.                                                 00001870
C                                                                       00001880
            DO 60 JJ = 1, JU                                            00001890
               J = JU - JJ + 1                                          00001900
               IF (QRAUX(J) .EQ. 0.0E0) GO TO 50                        00001910
                  TEMP = X(J,J)                                         00001920
                  X(J,J) = QRAUX(J)                                     00001930
                  T = -SDOT(N-J+1,X(J,J),1,QY(J),1)/X(J,J)              00001940
                  CALL SAXPY(N-J+1,T,X(J,J),1,QY(J),1)                  00001950
                  X(J,J) = TEMP                                         00001960
   50          CONTINUE                                                 00001970
   60       CONTINUE                                                    00001980
   70    CONTINUE                                                       00001990
         IF (.NOT.CQTY) GO TO 100                                       00002000
C                                                                       00002010
C           COMPUTE TRANS(Q)*Y.                                         00002020
C                                                                       00002030
            DO 90 J = 1, JU                                             00002040
               IF (QRAUX(J) .EQ. 0.0E0) GO TO 80                        00002050
                  TEMP = X(J,J)                                         00002060
                  X(J,J) = QRAUX(J)                                     00002070
                  T = -SDOT(N-J+1,X(J,J),1,QTY(J),1)/X(J,J)             00002080
                  CALL SAXPY(N-J+1,T,X(J,J),1,QTY(J),1)                 00002090
                  X(J,J) = TEMP                                         00002100
   80          CONTINUE                                                 00002110
   90       CONTINUE                                                    00002120
  100    CONTINUE                                                       00002130
C                                                                       00002140
C        SET UP TO COMPUTE B, RSD, OR XB.                               00002150
C                                                                       00002160
         IF (CB) CALL SCOPY(K,QTY,1,B,1)                                00002170
         KP1 = K + 1                                                    00002180
         IF (CXB) CALL SCOPY(K,QTY,1,XB,1)                              00002190
         IF (CR .AND. K .LT. N) CALL SCOPY(N-K,QTY(KP1),1,RSD(KP1),1)   00002200
         IF (.NOT.CXB .OR. KP1 .GT. N) GO TO 120                        00002210
            DO 110 I = KP1, N                                           00002220
               XB(I) = 0.0E0                                            00002230
  110       CONTINUE                                                    00002240
  120    CONTINUE                                                       00002250
         IF (.NOT.CR) GO TO 140                                         00002260
            DO 130 I = 1, K                                             00002270
               RSD(I) = 0.0E0                                           00002280
  130       CONTINUE                                                    00002290
  140    CONTINUE                                                       00002300
         IF (.NOT.CB) GO TO 190                                         00002310
C                                                                       00002320
C           COMPUTE B.                                                  00002330
C                                                                       00002340
            DO 170 JJ = 1, K                                            00002350
               J = K - JJ + 1                                           00002360
               IF (X(J,J) .NE. 0.0E0) GO TO 150                         00002370
                  INFO = J                                              00002380
C           ......EXIT                                                  00002390
                  GO TO 180                                             00002400
  150          CONTINUE                                                 00002410
               B(J) = B(J)/X(J,J)                                       00002420
               IF (J .EQ. 1) GO TO 160                                  00002430
                  T = -B(J)                                             00002440
                  CALL SAXPY(J-1,T,X(1,J),1,B,1)                        00002450
  160          CONTINUE                                                 00002460
  170       CONTINUE                                                    00002470
  180       CONTINUE                                                    00002480
  190    CONTINUE                                                       00002490
         IF (.NOT.CR .AND. .NOT.CXB) GO TO 240                          00002500
C                                                                       00002510
C           COMPUTE RSD OR XB AS REQUIRED.                              00002520
C                                                                       00002530
            DO 230 JJ = 1, JU                                           00002540
               J = JU - JJ + 1                                          00002550
               IF (QRAUX(J) .EQ. 0.0E0) GO TO 220                       00002560
                  TEMP = X(J,J)                                         00002570
                  X(J,J) = QRAUX(J)                                     00002580
                  IF (.NOT.CR) GO TO 200                                00002590
                     T = -SDOT(N-J+1,X(J,J),1,RSD(J),1)/X(J,J)          00002600
                     CALL SAXPY(N-J+1,T,X(J,J),1,RSD(J),1)              00002610
  200             CONTINUE                                              00002620
                  IF (.NOT.CXB) GO TO 210                               00002630
                     T = -SDOT(N-J+1,X(J,J),1,XB(J),1)/X(J,J)           00002640
                     CALL SAXPY(N-J+1,T,X(J,J),1,XB(J),1)               00002650
  210             CONTINUE                                              00002660
                  X(J,J) = TEMP                                         00002670
  220          CONTINUE                                                 00002680
  230       CONTINUE                                                    00002690
  240    CONTINUE                                                       00002700
  250 CONTINUE                                                          00002710
      RETURN                                                            00002720
      END                                                               00002730
