*#**********************************************************************

      SUBROUTINE STRSL(T,LDT,N,B,JOB,INFO)                              00000010

      INTEGER LDT,N,JOB,INFO                                            00000020
      REAL T(LDT,1),B(1)                                                00000030
C                                                                       00000040
C                                                                       00000050
C     STRSL SOLVES SYSTEMS OF THE FORM                                  00000060
C                                                                       00000070
C                   T * X = B                                           00000080
C     OR                                                                00000090
C                   TRANS(T) * X = B                                    00000100
C                                                                       00000110
C     WHERE T IS A TRIANGULAR MATRIX OF ORDER N. HERE TRANS(T)          00000120
C     DENOTES THE TRANSPOSE OF THE MATRIX T.                            00000130
C                                                                       00000140
C     ON ENTRY                                                          00000150
C                                                                       00000160
C         T         REAL(LDT,N)                                         00000170
C                   T CONTAINS THE MATRIX OF THE SYSTEM. THE ZERO       00000180
C                   ELEMENTS OF THE MATRIX ARE NOT REFERENCED, AND      00000190
C                   THE CORRESPONDING ELEMENTS OF THE ARRAY CAN BE      00000200
C                   USED TO STORE OTHER INFORMATION.                    00000210
C                                                                       00000220
C         LDT       INTEGER                                             00000230
C                   LDT IS THE LEADING DIMENSION OF THE ARRAY T.        00000240
C                                                                       00000250
C         N         INTEGER                                             00000260
C                   N IS THE ORDER OF THE SYSTEM.                       00000270
C                                                                       00000280
C         B         REAL(N).                                            00000290
C                   B CONTAINS THE RIGHT HAND SIDE OF THE SYSTEM.       00000300
C                                                                       00000310
C         JOB       INTEGER                                             00000320
C                   JOB SPECIFIES WHAT KIND OF SYSTEM IS TO BE SOLVED.  00000330
C                   IF JOB IS                                           00000340
C                                                                       00000350
C                        00   SOLVE T*X=B, T LOWER TRIANGULAR,          00000360
C                        01   SOLVE T*X=B, T UPPER TRIANGULAR,          00000370
C                        10   SOLVE TRANS(T)*X=B, T LOWER TRIANGULAR,   00000380
C                        11   SOLVE TRANS(T)*X=B, T UPPER TRIANGULAR.   00000390
C                                                                       00000400
C     ON RETURN                                                         00000410
C                                                                       00000420
C         B         B CONTAINS THE SOLUTION, IF INFO .EQ. 0.            00000430
C                   OTHERWISE B IS UNALTERED.                           00000440
C                                                                       00000450
C         INFO      INTEGER                                             00000460
C                   INFO CONTAINS ZERO IF THE SYSTEM IS NONSINGULAR.    00000470
C                   OTHERWISE INFO CONTAINS THE INDEX OF                00000480
C                   THE FIRST ZERO DIAGONAL ELEMENT OF T.               00000490
C                                                                       00000500
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000510
C     G. W. STEWART, UNIVERSITY OF MARYLAND, ARGONNE NATIONAL LAB.      00000520
C                                                                       00000530
C     SUBROUTINES AND FUNCTIONS                                         00000540
C                                                                       00000550
C     BLAS SAXPY,SDOT                                                   00000560
C     FORTRAN MOD                                                       00000570
C                                                                       00000580
C     INTERNAL VARIABLES                                                00000590
C                                                                       00000600
      REAL SDOT,TEMP                                                    00000610
      INTEGER CASE,J,JJ                                                 00000620
C                                                                       00000630
C     BEGIN BLOCK PERMITTING ...EXITS TO 150                            00000640
C                                                                       00000650
C        CHECK FOR ZERO DIAGONAL ELEMENTS.                              00000660
C                                                                       00000670
         DO 10 INFO = 1, N                                              00000680
C     ......EXIT                                                        00000690
            IF (T(INFO,INFO) .EQ. 0.0E0) GO TO 150                      00000700
   10    CONTINUE                                                       00000710
         INFO = 0                                                       00000720
C                                                                       00000730
C        DETERMINE THE TASK AND GO TO IT.                               00000740
C                                                                       00000750
         CASE = 1                                                       00000760
         IF (MOD(JOB,10) .NE. 0) CASE = 2                               00000770
         IF (MOD(JOB,100)/10 .NE. 0) CASE = CASE + 2                    00000780
         GO TO (20,50,80,110), CASE                                     00000790
C                                                                       00000800
C        SOLVE T*X=B FOR T LOWER TRIANGULAR                             00000810
C                                                                       00000820
   20    CONTINUE                                                       00000830
            B(1) = B(1)/T(1,1)                                          00000840
            IF (N .LT. 2) GO TO 40                                      00000850
            DO 30 J = 2, N                                              00000860
               TEMP = -B(J-1)                                           00000870
               CALL SAXPY(N-J+1,TEMP,T(J,J-1),1,B(J),1)                 00000880
               B(J) = B(J)/T(J,J)                                       00000890
   30       CONTINUE                                                    00000900
   40       CONTINUE                                                    00000910
         GO TO 140                                                      00000920
C                                                                       00000930
C        SOLVE T*X=B FOR T UPPER TRIANGULAR.                            00000940
C                                                                       00000950
   50    CONTINUE                                                       00000960
            B(N) = B(N)/T(N,N)                                          00000970
            IF (N .LT. 2) GO TO 70                                      00000980
            DO 60 JJ = 2, N                                             00000990
               J = N - JJ + 1                                           00001000
               TEMP = -B(J+1)                                           00001010
               CALL SAXPY(J,TEMP,T(1,J+1),1,B(1),1)                     00001020
               B(J) = B(J)/T(J,J)                                       00001030
   60       CONTINUE                                                    00001040
   70       CONTINUE                                                    00001050
         GO TO 140                                                      00001060
C                                                                       00001070
C        SOLVE TRANS(T)*X=B FOR T LOWER TRIANGULAR.                     00001080
C                                                                       00001090
   80    CONTINUE                                                       00001100
            B(N) = B(N)/T(N,N)                                          00001110
            IF (N .LT. 2) GO TO 100                                     00001120
            DO 90 JJ = 2, N                                             00001130
               J = N - JJ + 1                                           00001140
               B(J) = B(J) - SDOT(JJ-1,T(J+1,J),1,B(J+1),1)             00001150
               B(J) = B(J)/T(J,J)                                       00001160
   90       CONTINUE                                                    00001170
  100       CONTINUE                                                    00001180
         GO TO 140                                                      00001190
C                                                                       00001200
C        SOLVE TRANS(T)*X=B FOR T UPPER TRIANGULAR.                     00001210
C                                                                       00001220
  110    CONTINUE                                                       00001230
            B(1) = B(1)/T(1,1)                                          00001240
            IF (N .LT. 2) GO TO 130                                     00001250
            DO 120 J = 2, N                                             00001260
               B(J) = B(J) - SDOT(J-1,T(1,J),1,B(1),1)                  00001270
               B(J) = B(J)/T(J,J)                                       00001280
  120       CONTINUE                                                    00001290
  130       CONTINUE                                                    00001300
  140    CONTINUE                                                       00001310
  150 CONTINUE                                                          00001320
      RETURN                                                            00001330
      END                                                               00001340
