C
*#**********************************************************************

c     COMPLEX FUNCTION ZDOTC*16(N,ZX,INCX,ZY,INCY)                      
      COMPLEX*16 FUNCTION ZDOTC(N,ZX,INCX,ZY,INCY)                      
C                                                                       
C     FORMS THE DOT PRODUCT OF A VECTOR.                                
C     JACK DONGARRA, 3/11/78.                                           
C                                                                       
      COMPLEX*16 ZX(1),ZY(1),ZTEMP                                      
      ZTEMP = (0.0D0,0.0D0)                                             
      ZDOTC = (0.0D0,0.0D0)                                             
      IF(N.LE.0)RETURN                                                  
      IF(INCX.EQ.1.AND.INCY.EQ.1)GO TO 20                               
C                                                                       
C        CODE FOR UNEQUAL INCREMENTS OR EQUAL INCREMENTS                
C          NOT EQUAL TO 1                                               
C                                                                       
      IX = 1                                                            
      IY = 1                                                            
      IF(INCX.LT.0)IX = (-N+1)*INCX + 1                                 
      IF(INCY.LT.0)IY = (-N+1)*INCY + 1                                 
      DO 10 I = 1,N                                                     
        ZTEMP = ZTEMP + DCONJG(ZX(IX))*ZY(IY)                           
        IX = IX + INCX                                                  
        IY = IY + INCY                                                  
   10 CONTINUE                                                          
      ZDOTC = ZTEMP                                                     
      RETURN                                                            
C                                                                       
C        CODE FOR BOTH INCREMENTS EQUAL TO 1                            
C                                                                       
   20 DO 30 I = 1,N                                                     
        ZTEMP = ZTEMP + DCONJG(ZX(I))*ZY(I)                             
   30 CONTINUE                                                          
      ZDOTC = ZTEMP                                                     
      RETURN                                                            
      END                                                               
