*#**********************************************************************

      SUBROUTINE ZGTSL(N,C,D,E,B,INFO)                                  00000010

      INTEGER N,INFO                                                    00000020
      COMPLEX*16 C(1),D(1),E(1),B(1)                                    00000030
C                                                                       00000040
C     ZGTSL GIVEN A GENERAL TRIDIAGONAL MATRIX AND A RIGHT HAND         00000050
C     SIDE WILL FIND THE SOLUTION.                                      00000060
C                                                                       00000070
C     ON ENTRY                                                          00000080
C                                                                       00000090
C        N       INTEGER                                                00000100
C                IS THE ORDER OF THE TRIDIAGONAL MATRIX.                00000110
C                                                                       00000120
C        C       COMPLEX*16(N)                                          00000130
C                IS THE SUBDIAGONAL OF THE TRIDIAGONAL MATRIX.          00000140
C                C(2) THROUGH C(N) SHOULD CONTAIN THE SUBDIAGONAL.      00000150
C                ON OUTPUT C IS DESTROYED.                              00000160
C                                                                       00000170
C        D       COMPLEX*16(N)                                          00000180
C                IS THE DIAGONAL OF THE TRIDIAGONAL MATRIX.             00000190
C                ON OUTPUT D IS DESTROYED.                              00000200
C                                                                       00000210
C        E       COMPLEX*16(N)                                          00000220
C                IS THE SUPERDIAGONAL OF THE TRIDIAGONAL MATRIX.        00000230
C                E(1) THROUGH E(N-1) SHOULD CONTAIN THE SUPERDIAGONAL.  00000240
C                ON OUTPUT E IS DESTROYED.                              00000250
C                                                                       00000260
C        B       COMPLEX*16(N)                                          00000270
C                IS THE RIGHT HAND SIDE VECTOR.                         00000280
C                                                                       00000290
C     ON RETURN                                                         00000300
C                                                                       00000310
C        B       IS THE SOLUTION VECTOR.                                00000320
C                                                                       00000330
C        INFO    INTEGER                                                00000340
C                = 0 NORMAL VALUE.                                      00000350
C                = K IF THE K-TH ELEMENT OF THE DIAGONAL BECOMES        00000360
C                    EXACTLY ZERO.  THE SUBROUTINE RETURNS WHEN         00000370
C                    THIS IS DETECTED.                                  00000380
C                                                                       00000390
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000400
C     JACK DONGARRA, ARGONNE NATIONAL LABORATORY.                       00000410
C                                                                       00000420
C     NO EXTERNALS                                                      00000430
C     FORTRAN DABS                                                      00000440
C                                                                       00000450
C     INTERNAL VARIABLES                                                00000460
C                                                                       00000470
      INTEGER K,KB,KP1,NM1,NM2                                          00000480
      COMPLEX*16 T                                                      00000490
      COMPLEX*16 ZDUM                                                   00000500
      DOUBLE PRECISION CABS1                                            00000510
      DOUBLE PRECISION DREAL,DIMAG                                      00000520
      COMPLEX*16 ZDUMR,ZDUMI                                            00000530
      DREAL(ZDUMR) = ZDUMR                                              00000540
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00000550
      CABS1(ZDUM) = DABS(DREAL(ZDUM)) + DABS(DIMAG(ZDUM))               00000560
C     BEGIN BLOCK PERMITTING ...EXITS TO 100                            00000570
C                                                                       00000580
         INFO = 0                                                       00000590
         C(1) = D(1)                                                    00000600
         NM1 = N - 1                                                    00000610
         IF (NM1 .LT. 1) GO TO 40                                       00000620
            D(1) = E(1)                                                 00000630
            E(1) = (0.0D0,0.0D0)                                        00000640
            E(N) = (0.0D0,0.0D0)                                        00000650
C                                                                       00000660
            DO 30 K = 1, NM1                                            00000670
               KP1 = K + 1                                              00000680
C                                                                       00000690
C              FIND THE LARGEST OF THE TWO ROWS                         00000700
C                                                                       00000710
               IF (CABS1(C(KP1)) .LT. CABS1(C(K))) GO TO 10             00000720
C                                                                       00000730
C                 INTERCHANGE ROW                                       00000740
C                                                                       00000750
                  T = C(KP1)                                            00000760
                  C(KP1) = C(K)                                         00000770
                  C(K) = T                                              00000780
                  T = D(KP1)                                            00000790
                  D(KP1) = D(K)                                         00000800
                  D(K) = T                                              00000810
                  T = E(KP1)                                            00000820
                  E(KP1) = E(K)                                         00000830
                  E(K) = T                                              00000840
                  T = B(KP1)                                            00000850
                  B(KP1) = B(K)                                         00000860
                  B(K) = T                                              00000870
   10          CONTINUE                                                 00000880
C                                                                       00000890
C              ZERO ELEMENTS                                            00000900
C                                                                       00000910
               IF (CABS1(C(K)) .NE. 0.0D0) GO TO 20                     00000920
                  INFO = K                                              00000930
C     ............EXIT                                                  00000940
                  GO TO 100                                             00000950
   20          CONTINUE                                                 00000960
               T = -C(KP1)/C(K)                                         00000970
               C(KP1) = D(KP1) + T*D(K)                                 00000980
               D(KP1) = E(KP1) + T*E(K)                                 00000990
               E(KP1) = (0.0D0,0.0D0)                                   00001000
               B(KP1) = B(KP1) + T*B(K)                                 00001010
   30       CONTINUE                                                    00001020
   40    CONTINUE                                                       00001030
         IF (CABS1(C(N)) .NE. 0.0D0) GO TO 50                           00001040
            INFO = N                                                    00001050
         GO TO 90                                                       00001060
   50    CONTINUE                                                       00001070
C                                                                       00001080
C           BACK SOLVE                                                  00001090
C                                                                       00001100
            NM2 = N - 2                                                 00001110
            B(N) = B(N)/C(N)                                            00001120
            IF (N .EQ. 1) GO TO 80                                      00001130
               B(NM1) = (B(NM1) - D(NM1)*B(N))/C(NM1)                   00001140
               IF (NM2 .LT. 1) GO TO 70                                 00001150
               DO 60 KB = 1, NM2                                        00001160
                  K = NM2 - KB + 1                                      00001170
                  B(K) = (B(K) - D(K)*B(K+1) - E(K)*B(K+2))/C(K)        00001180
   60          CONTINUE                                                 00001190
   70          CONTINUE                                                 00001200
   80       CONTINUE                                                    00001210
   90    CONTINUE                                                       00001220
  100 CONTINUE                                                          00001230
C                                                                       00001240
      RETURN                                                            00001250
      END                                                               00001260
