*#**********************************************************************

      SUBROUTINE ZPPCO(AP,N,RCOND,Z,INFO)                               00000010

      INTEGER N,INFO                                                    00000020
      COMPLEX*16 AP(1),Z(1)                                             00000030
      DOUBLE PRECISION RCOND                                            00000040
C                                                                       00000050
C     ZPPCO FACTORS A COMPLEX*16 HERMITIAN POSITIVE DEFINITE MATRIX     00000060
C     STORED IN PACKED FORM                                             00000070
C     AND ESTIMATES THE CONDITION OF THE MATRIX.                        00000080
C                                                                       00000090
C     IF  RCOND  IS NOT NEEDED, ZPPFA IS SLIGHTLY FASTER.               00000100
C     TO SOLVE  A*X = B , FOLLOW ZPPCO BY ZPPSL.                        00000110
C     TO COMPUTE  INVERSE(A)*C , FOLLOW ZPPCO BY ZPPSL.                 00000120
C     TO COMPUTE  DETERMINANT(A) , FOLLOW ZPPCO BY ZPPDI.               00000130
C     TO COMPUTE  INVERSE(A) , FOLLOW ZPPCO BY ZPPDI.                   00000140
C                                                                       00000150
C     ON ENTRY                                                          00000160
C                                                                       00000170
C        AP      COMPLEX*16 (N*(N+1)/2)                                 00000180
C                THE PACKED FORM OF A HERMITIAN MATRIX  A .  THE        00000190
C                COLUMNS OF THE UPPER TRIANGLE ARE STORED SEQUENTIALLY  00000200
C                IN A ONE-DIMENSIONAL ARRAY OF LENGTH  N*(N+1)/2 .      00000210
C                SEE COMMENTS BELOW FOR DETAILS.                        00000220
C                                                                       00000230
C        N       INTEGER                                                00000240
C                THE ORDER OF THE MATRIX  A .                           00000250
C                                                                       00000260
C     ON RETURN                                                         00000270
C                                                                       00000280
C        AP      AN UPPER TRIANGULAR MATRIX  R , STORED IN PACKED       00000290
C                FORM, SO THAT  A = CTRANS(R)*R .                       00000300
C                IF  INFO .NE. 0 , THE FACTORIZATION IS NOT COMPLETE.   00000310
C                                                                       00000320
C        RCOND   DOUBLE PRECISION                                       00000330
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .        00000340
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS       00000350
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000360
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000370
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000380
C                           1.0 + RCOND .EQ. 1.0                        00000390
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING           00000400
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000410
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000420
C                UNDERFLOWS.  IF INFO .NE. 0 , RCOND IS UNCHANGED.      00000430
C                                                                       00000440
C        Z       COMPLEX*16(N)                                          00000450
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000460
C                IF  A  IS SINGULAR TO WORKING PRECISION, THEN  Z  IS   00000470
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000480
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000490
C                IF  INFO .NE. 0 , Z  IS UNCHANGED.                     00000500
C                                                                       00000510
C        INFO    INTEGER                                                00000520
C                = 0  FOR NORMAL RETURN.                                00000530
C                = K  SIGNALS AN ERROR CONDITION.  THE LEADING MINOR    00000540
C                     OF ORDER  K  IS NOT POSITIVE DEFINITE.            00000550
C                                                                       00000560
C     PACKED STORAGE                                                    00000570
C                                                                       00000580
C          THE FOLLOWING PROGRAM SEGMENT WILL PACK THE UPPER            00000590
C          TRIANGLE OF A HERMITIAN MATRIX.                              00000600
C                                                                       00000610
C                K = 0                                                  00000620
C                DO 20 J = 1, N                                         00000630
C                   DO 10 I = 1, J                                      00000640
C                      K = K + 1                                        00000650
C                      AP(K) = A(I,J)                                   00000660
C             10    CONTINUE                                            00000670
C             20 CONTINUE                                               00000680
C                                                                       00000690
C     LINPACK.  THIS VERSION DATED 08/14/78 .                           00000700
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000710
C                                                                       00000720
C     SUBROUTINES AND FUNCTIONS                                         00000730
C                                                                       00000740
C     LINPACK ZPPFA                                                     00000750
C     BLAS ZAXPY,ZDOTC,ZDSCAL,DZASUM                                    00000760
C     FORTRAN DABS,DMAX1,DCMPLX,DCONJG                                  00000770
C                                                                       00000780
C     INTERNAL VARIABLES                                                00000790
C                                                                       00000800
      COMPLEX*16 ZDOTC,EK,T,WK,WKM                                      00000810
      DOUBLE PRECISION ANORM,S,DZASUM,SM,YNORM                          00000820
      INTEGER I,IJ,J,JM1,J1,K,KB,KJ,KK,KP1                              00000830
C                                                                       00000840
      COMPLEX*16 ZDUM,ZDUM2,CSIGN1                                      00000850
      DOUBLE PRECISION CABS1                                            00000860
      DOUBLE PRECISION DREAL,DIMAG                                      00000870
      COMPLEX*16 ZDUMR,ZDUMI                                            00000880
      DREAL(ZDUMR) = ZDUMR                                              00000890
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00000900
      CABS1(ZDUM) = DABS(DREAL(ZDUM)) + DABS(DIMAG(ZDUM))               00000910
      CSIGN1(ZDUM,ZDUM2) = CABS1(ZDUM)*(ZDUM2/CABS1(ZDUM2))             00000920
C                                                                       00000930
C     FIND NORM OF A                                                    00000940
C                                                                       00000950
      J1 = 1                                                            00000960
      DO 30 J = 1, N                                                    00000970
         Z(J) = DCMPLX(DZASUM(J,AP(J1),1),0.0D0)                        00000980
         IJ = J1                                                        00000990
         J1 = J1 + J                                                    00001000
         JM1 = J - 1                                                    00001010
         IF (JM1 .LT. 1) GO TO 20                                       00001020
         DO 10 I = 1, JM1                                               00001030
            Z(I) = DCMPLX(DREAL(Z(I))+CABS1(AP(IJ)),0.0D0)              00001040
            IJ = IJ + 1                                                 00001050
   10    CONTINUE                                                       00001060
   20    CONTINUE                                                       00001070
   30 CONTINUE                                                          00001080
      ANORM = 0.0D0                                                     00001090
      DO 40 J = 1, N                                                    00001100
         ANORM = DMAX1(ANORM,DREAL(Z(J)))                               00001110
   40 CONTINUE                                                          00001120
C                                                                       00001130
C     FACTOR                                                            00001140
C                                                                       00001150
      CALL ZPPFA(AP,N,INFO)                                             00001160
      IF (INFO .NE. 0) GO TO 180                                        00001170
C                                                                       00001180
C        RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .           00001190
C        ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  A*Y = E .      00001200
C        THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL        00001210
C        GROWTH IN THE ELEMENTS OF W  WHERE  CTRANS(R)*W = E .          00001220
C        THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.         00001230
C                                                                       00001240
C        SOLVE CTRANS(R)*W = E                                          00001250
C                                                                       00001260
         EK = (1.0D0,0.0D0)                                             00001270
         DO 50 J = 1, N                                                 00001280
            Z(J) = (0.0D0,0.0D0)                                        00001290
   50    CONTINUE                                                       00001300
         KK = 0                                                         00001310
         DO 110 K = 1, N                                                00001320
            KK = KK + K                                                 00001330
            IF (CABS1(Z(K)) .NE. 0.0D0) EK = CSIGN1(EK,-Z(K))           00001340
            IF (CABS1(EK-Z(K)) .LE. DREAL(AP(KK))) GO TO 60             00001350
               S = DREAL(AP(KK))/CABS1(EK-Z(K))                         00001360
               CALL ZDSCAL(N,S,Z,1)                                     00001370
               EK = DCMPLX(S,0.0D0)*EK                                  00001380
   60       CONTINUE                                                    00001390
            WK = EK - Z(K)                                              00001400
            WKM = -EK - Z(K)                                            00001410
            S = CABS1(WK)                                               00001420
            SM = CABS1(WKM)                                             00001430
            WK = WK/AP(KK)                                              00001440
            WKM = WKM/AP(KK)                                            00001450
            KP1 = K + 1                                                 00001460
            KJ = KK + K                                                 00001470
            IF (KP1 .GT. N) GO TO 100                                   00001480
               DO 70 J = KP1, N                                         00001490
                  SM = SM + CABS1(Z(J)+WKM*DCONJG(AP(KJ)))              00001500
                  Z(J) = Z(J) + WK*DCONJG(AP(KJ))                       00001510
                  S = S + CABS1(Z(J))                                   00001520
                  KJ = KJ + J                                           00001530
   70          CONTINUE                                                 00001540
               IF (S .GE. SM) GO TO 90                                  00001550
                  T = WKM - WK                                          00001560
                  WK = WKM                                              00001570
                  KJ = KK + K                                           00001580
                  DO 80 J = KP1, N                                      00001590
                     Z(J) = Z(J) + T*DCONJG(AP(KJ))                     00001600
                     KJ = KJ + J                                        00001610
   80             CONTINUE                                              00001620
   90          CONTINUE                                                 00001630
  100       CONTINUE                                                    00001640
            Z(K) = WK                                                   00001650
  110    CONTINUE                                                       00001660
         S = 1.0D0/DZASUM(N,Z,1)                                        00001670
         CALL ZDSCAL(N,S,Z,1)                                           00001680
C                                                                       00001690
C        SOLVE R*Y = W                                                  00001700
C                                                                       00001710
         DO 130 KB = 1, N                                               00001720
            K = N + 1 - KB                                              00001730
            IF (CABS1(Z(K)) .LE. DREAL(AP(KK))) GO TO 120               00001740
               S = DREAL(AP(KK))/CABS1(Z(K))                            00001750
               CALL ZDSCAL(N,S,Z,1)                                     00001760
  120       CONTINUE                                                    00001770
            Z(K) = Z(K)/AP(KK)                                          00001780
            KK = KK - K                                                 00001790
            T = -Z(K)                                                   00001800
            CALL ZAXPY(K-1,T,AP(KK+1),1,Z(1),1)                         00001810
  130    CONTINUE                                                       00001820
         S = 1.0D0/DZASUM(N,Z,1)                                        00001830
         CALL ZDSCAL(N,S,Z,1)                                           00001840
C                                                                       00001850
         YNORM = 1.0D0                                                  00001860
C                                                                       00001870
C        SOLVE CTRANS(R)*V = Y                                          00001880
C                                                                       00001890
         DO 150 K = 1, N                                                00001900
            Z(K) = Z(K) - ZDOTC(K-1,AP(KK+1),1,Z(1),1)                  00001910
            KK = KK + K                                                 00001920
            IF (CABS1(Z(K)) .LE. DREAL(AP(KK))) GO TO 140               00001930
               S = DREAL(AP(KK))/CABS1(Z(K))                            00001940
               CALL ZDSCAL(N,S,Z,1)                                     00001950
               YNORM = S*YNORM                                          00001960
  140       CONTINUE                                                    00001970
            Z(K) = Z(K)/AP(KK)                                          00001980
  150    CONTINUE                                                       00001990
         S = 1.0D0/DZASUM(N,Z,1)                                        00002000
         CALL ZDSCAL(N,S,Z,1)                                           00002010
         YNORM = S*YNORM                                                00002020
C                                                                       00002030
C        SOLVE R*Z = V                                                  00002040
C                                                                       00002050
         DO 170 KB = 1, N                                               00002060
            K = N + 1 - KB                                              00002070
            IF (CABS1(Z(K)) .LE. DREAL(AP(KK))) GO TO 160               00002080
               S = DREAL(AP(KK))/CABS1(Z(K))                            00002090
               CALL ZDSCAL(N,S,Z,1)                                     00002100
               YNORM = S*YNORM                                          00002110
  160       CONTINUE                                                    00002120
            Z(K) = Z(K)/AP(KK)                                          00002130
            KK = KK - K                                                 00002140
            T = -Z(K)                                                   00002150
            CALL ZAXPY(K-1,T,AP(KK+1),1,Z(1),1)                         00002160
  170    CONTINUE                                                       00002170
C        MAKE ZNORM = 1.0                                               00002180
         S = 1.0D0/DZASUM(N,Z,1)                                        00002190
         CALL ZDSCAL(N,S,Z,1)                                           00002200
         YNORM = S*YNORM                                                00002210
C                                                                       00002220
         IF (ANORM .NE. 0.0D0) RCOND = YNORM/ANORM                      00002230
         IF (ANORM .EQ. 0.0D0) RCOND = 0.0D0                            00002240
  180 CONTINUE                                                          00002250
      RETURN                                                            00002260
      END                                                               00002270
