*#**********************************************************************

      SUBROUTINE ZSVDC(X,LDX,N,P,S,E,U,LDU,V,LDV,WORK,JOB,INFO)         00000010

      INTEGER LDX,N,P,LDU,LDV,JOB,INFO                                  00000020
      COMPLEX*16 X(LDX,1),S(1),E(1),U(LDU,1),V(LDV,1),WORK(1)           00000030
C                                                                       00000040
C                                                                       00000050
C     ZSVDC IS A SUBROUTINE TO REDUCE A COMPLEX*16 NXP MATRIX X BY      00000060
C     UNITARY TRANSFORMATIONS U AND V TO DIAGONAL FORM.  THE            00000070
C     DIAGONAL ELEMENTS S(I) ARE THE SINGULAR VALUES OF X.  THE         00000080
C     COLUMNS OF U ARE THE CORRESPONDING LEFT SINGULAR VECTORS,         00000090
C     AND THE COLUMNS OF V THE RIGHT SINGULAR VECTORS.                  00000100
C                                                                       00000110
C     ON ENTRY                                                          00000120
C                                                                       00000130
C         X         COMPLEX*16(LDX,P), WHERE LDX.GE.N.                  00000140
C                   X CONTAINS THE MATRIX WHOSE SINGULAR VALUE          00000150
C                   DECOMPOSITION IS TO BE COMPUTED.  X IS              00000160
C                   DESTROYED BY ZSVDC.                                 00000170
C                                                                       00000180
C         LDX       INTEGER.                                            00000190
C                   LDX IS THE LEADING DIMENSION OF THE ARRAY X.        00000200
C                                                                       00000210
C         N         INTEGER.                                            00000220
C                   N IS THE NUMBER OF COLUMNS OF THE MATRIX X.         00000230
C                                                                       00000240
C         P         INTEGER.                                            00000250
C                   P IS THE NUMBER OF ROWS OF THE MATRIX X.            00000260
C                                                                       00000270
C         LDU       INTEGER.                                            00000280
C                   LDU IS THE LEADING DIMENSION OF THE ARRAY U         00000290
C                   (SEE BELOW).                                        00000300
C                                                                       00000310
C         LDV       INTEGER.                                            00000320
C                   LDV IS THE LEADING DIMENSION OF THE ARRAY V         00000330
C                   (SEE BELOW).                                        00000340
C                                                                       00000350
C         WORK      COMPLEX*16(N).                                      00000360
C                   WORK IS A SCRATCH ARRAY.                            00000370
C                                                                       00000380
C         JOB       INTEGER.                                            00000390
C                   JOB CONTROLS THE COMPUTATION OF THE SINGULAR        00000400
C                   VECTORS.  IT HAS THE DECIMAL EXPANSION AB           00000410
C                   WITH THE FOLLOWING MEANING                          00000420
C                                                                       00000430
C                        A.EQ.0    DO NOT COMPUTE THE LEFT SINGULAR     00000440
C                                  VECTORS.                             00000450
C                        A.EQ.1    RETURN THE N LEFT SINGULAR VECTORS   00000460
C                                  IN U.                                00000470
C                        A.GE.2    RETURNS THE FIRST MIN(N,P)           00000480
C                                  LEFT SINGULAR VECTORS IN U.          00000490
C                        B.EQ.0    DO NOT COMPUTE THE RIGHT SINGULAR    00000500
C                                  VECTORS.                             00000510
C                        B.EQ.1    RETURN THE RIGHT SINGULAR VECTORS    00000520
C                                  IN V.                                00000530
C                                                                       00000540
C     ON RETURN                                                         00000550
C                                                                       00000560
C         S         COMPLEX*16(MM), WHERE MM=MIN(N+1,P).                00000570
C                   THE FIRST MIN(N,P) ENTRIES OF S CONTAIN THE         00000580
C                   SINGULAR VALUES OF X ARRANGED IN DESCENDING         00000590
C                   ORDER OF MAGNITUDE.                                 00000600
C                                                                       00000610
C         E         COMPLEX*16(P).                                      00000620
C                   E ORDINARILY CONTAINS ZEROS.  HOWEVER SEE THE       00000630
C                   DISCUSSION OF INFO FOR EXCEPTIONS.                  00000640
C                                                                       00000650
C         U         COMPLEX*16(LDU,K), WHERE LDU.GE.N.  IF JOBA.EQ.1    00000660
C                                   THEN K.EQ.N, IF JOBA.GE.2 THEN      00000670
C                                                                       00000680
C                                   K.EQ.MIN(N,P).                      00000690
C                   U CONTAINS THE MATRIX OF RIGHT SINGULAR VECTORS.    00000700
C                   U IS NOT REFERENCED IF JOBA.EQ.0.  IF N.LE.P        00000710
C                   OR IF JOBA.GT.2, THEN U MAY BE IDENTIFIED WITH X    00000720
C                   IN THE SUBROUTINE CALL.                             00000730
C                                                                       00000740
C         V         COMPLEX*16(LDV,P), WHERE LDV.GE.P.                  00000750
C                   V CONTAINS THE MATRIX OF RIGHT SINGULAR VECTORS.    00000760
C                   V IS NOT REFERENCED IF JOBB.EQ.0.  IF P.LE.N,       00000770
C                   THEN V MAY BE IDENTIFIED WHTH X IN THE              00000780
C                   SUBROUTINE CALL.                                    00000790
C                                                                       00000800
C         INFO      INTEGER.                                            00000810
C                   THE SINGULAR VALUES (AND THEIR CORRESPONDING        00000820
C                   SINGULAR VECTORS) S(INFO+1),S(INFO+2),...,S(M)      00000830
C                   ARE CORRECT (HERE M=MIN(N,P)).  THUS IF             00000840
C                   INFO.EQ.0, ALL THE SINGULAR VALUES AND THEIR        00000850
C                   VECTORS ARE CORRECT.  IN ANY EVENT, THE MATRIX      00000860
C                   B = CTRANS(U)*X*V IS THE BIDIAGONAL MATRIX          00000870
C                   WITH THE ELEMENTS OF S ON ITS DIAGONAL AND THE      00000880
C                   ELEMENTS OF E ON ITS SUPER-DIAGONAL (CTRANS(U)      00000890
C                   IS THE CONJUGATE-TRANSPOSE OF U).  THUS THE         00000900
C                   SINGULAR VALUES OF X AND B ARE THE SAME.            00000910
C                                                                       00000920
C     LINPACK. THIS VERSION DATED 03/19/79 .                            00000930
C     G.W. STEWART, UNIVERSITY OF MARYLAND, ARGONNE NATIONAL LAB.       00000940
C                                                                       00000950
C     ZSVDC USES THE FOLLOWING FUNCTIONS AND SUBPROGRAMS.               00000960
C                                                                       00000970
C     EXTERNAL ZDROT                                                    00000980
C     BLAS ZAXPY,ZDOTC,ZSCAL,ZSWAP,DZNRM2,DROTG                         00000990
C     FORTRAN DABS,DMAX1,CDABS,DCMPLX                                   00001000
C     FORTRAN DCONJG,MAX0,MIN0,MOD,DSQRT                                00001010
C                                                                       00001020
C     INTERNAL VARIABLES                                                00001030
C                                                                       00001040
      INTEGER I,ITER,J,JOBU,K,KASE,KK,L,LL,LLS,LM1,LP1,LS,LU,M,MAXIT,   00001050
     *        MM,MM1,MP1,NCT,NCTP1,NCU,NRT,NRTP1                        00001060
      COMPLEX*16 ZDOTC,T,R                                              00001070
      DOUBLE PRECISION B,C,CS,EL,EMM1,F,G,DZNRM2,SCALE,SHIFT,SL,SM,SN,  00001080
     *                 SMM1,T1,TEST,ZTEST                               00001090
      LOGICAL WANTU,WANTV                                               00001100
C                                                                       00001110
      COMPLEX*16 CSIGN,ZDUM,ZDUM1,ZDUM2                                 00001120
      DOUBLE PRECISION CABS1                                            00001130
      DOUBLE PRECISION DREAL,DIMAG                                      00001140
      COMPLEX*16 ZDUMR,ZDUMI                                            00001150
      DREAL(ZDUMR) = ZDUMR                                              00001160
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00001170
      CABS1(ZDUM) = DABS(DREAL(ZDUM)) + DABS(DIMAG(ZDUM))               00001180
      CSIGN(ZDUM1,ZDUM2) = CDABS(ZDUM1)*(ZDUM2/CDABS(ZDUM2))            00001190
C                                                                       00001200
C     SET THE MAXIMUM NUMBER OF ITERATIONS.                             00001210
C                                                                       00001220
      MAXIT = 30                                                        00001230
C                                                                       00001240
C     DETERMINE WHAT IS TO BE COMPUTED.                                 00001250
C                                                                       00001260
      WANTU = .FALSE.                                                   00001270
      WANTV = .FALSE.                                                   00001280
      JOBU = MOD(JOB,100)/10                                            00001290
      NCU = N                                                           00001300
      IF (JOBU .GT. 1) NCU = MIN0(N,P)                                  00001310
      IF (JOBU .NE. 0) WANTU = .TRUE.                                   00001320
      IF (MOD(JOB,10) .NE. 0) WANTV = .TRUE.                            00001330
C                                                                       00001340
C     REDUCE X TO BIDIAGONAL FORM, STORING THE DIAGONAL ELEMENTS        00001350
C     IN S AND THE SUPER-DIAGONAL ELEMENTS IN E.                        00001360
C                                                                       00001370
      INFO = 0                                                          00001380
      NCT = MIN0(N-1,P)                                                 00001390
      NRT = MAX0(0,MIN0(P-2,N))                                         00001400
      LU = MAX0(NCT,NRT)                                                00001410
      IF (LU .LT. 1) GO TO 170                                          00001420
      DO 160 L = 1, LU                                                  00001430
         LP1 = L + 1                                                    00001440
         IF (L .GT. NCT) GO TO 20                                       00001450
C                                                                       00001460
C           COMPUTE THE TRANSFORMATION FOR THE L-TH COLUMN AND          00001470
C           PLACE THE L-TH DIAGONAL IN S(L).                            00001480
C                                                                       00001490
            S(L) = DCMPLX(DZNRM2(N-L+1,X(L,L),1),0.0D0)                 00001500
            IF (CABS1(S(L)) .EQ. 0.0D0) GO TO 10                        00001510
               IF (CABS1(X(L,L)) .NE. 0.0D0) S(L) = CSIGN(S(L),X(L,L))  00001520
               CALL ZSCAL(N-L+1,1.0D0/S(L),X(L,L),1)                    00001530
               X(L,L) = (1.0D0,0.0D0) + X(L,L)                          00001540
   10       CONTINUE                                                    00001550
            S(L) = -S(L)                                                00001560
   20    CONTINUE                                                       00001570
         IF (P .LT. LP1) GO TO 50                                       00001580
         DO 40 J = LP1, P                                               00001590
            IF (L .GT. NCT) GO TO 30                                    00001600
            IF (CABS1(S(L)) .EQ. 0.0D0) GO TO 30                        00001610
C                                                                       00001620
C              APPLY THE TRANSFORMATION.                                00001630
C                                                                       00001640
               T = -ZDOTC(N-L+1,X(L,L),1,X(L,J),1)/X(L,L)               00001650
               CALL ZAXPY(N-L+1,T,X(L,L),1,X(L,J),1)                    00001660
   30       CONTINUE                                                    00001670
C                                                                       00001680
C           PLACE THE L-TH ROW OF X INTO  E FOR THE                     00001690
C           SUBSEQUENT CALCULATION OF THE ROW TRANSFORMATION.           00001700
C                                                                       00001710
            E(J) = DCONJG(X(L,J))                                       00001720
   40    CONTINUE                                                       00001730
   50    CONTINUE                                                       00001740
         IF (.NOT.WANTU .OR. L .GT. NCT) GO TO 70                       00001750
C                                                                       00001760
C           PLACE THE TRANSFORMATION IN U FOR SUBSEQUENT BACK           00001770
C           MULTIPLICATION.                                             00001780
C                                                                       00001790
            DO 60 I = L, N                                              00001800
               U(I,L) = X(I,L)                                          00001810
   60       CONTINUE                                                    00001820
   70    CONTINUE                                                       00001830
         IF (L .GT. NRT) GO TO 150                                      00001840
C                                                                       00001850
C           COMPUTE THE L-TH ROW TRANSFORMATION AND PLACE THE           00001860
C           L-TH SUPER-DIAGONAL IN E(L).                                00001870
C                                                                       00001880
            E(L) = DCMPLX(DZNRM2(P-L,E(LP1),1),0.0D0)                   00001890
            IF (CABS1(E(L)) .EQ. 0.0D0) GO TO 80                        00001900
               IF (CABS1(E(LP1)) .NE. 0.0D0) E(L) = CSIGN(E(L),E(LP1))  00001910
               CALL ZSCAL(P-L,1.0D0/E(L),E(LP1),1)                      00001920
               E(LP1) = (1.0D0,0.0D0) + E(LP1)                          00001930
   80       CONTINUE                                                    00001940
            E(L) = -DCONJG(E(L))                                        00001950
            IF (LP1 .GT. N .OR. CABS1(E(L)) .EQ. 0.0D0) GO TO 120       00001960
C                                                                       00001970
C              APPLY THE TRANSFORMATION.                                00001980
C                                                                       00001990
               DO 90 I = LP1, N                                         00002000
                  WORK(I) = (0.0D0,0.0D0)                               00002010
   90          CONTINUE                                                 00002020
               DO 100 J = LP1, P                                        00002030
                  CALL ZAXPY(N-L,E(J),X(LP1,J),1,WORK(LP1),1)           00002040
  100          CONTINUE                                                 00002050
               DO 110 J = LP1, P                                        00002060
                  CALL ZAXPY(N-L,DCONJG(-E(J)/E(LP1)),WORK(LP1),1,      00002070
     *                       X(LP1,J),1)                                00002080
  110          CONTINUE                                                 00002090
  120       CONTINUE                                                    00002100
            IF (.NOT.WANTV) GO TO 140                                   00002110
C                                                                       00002120
C              PLACE THE TRANSFORMATION IN V FOR SUBSEQUENT             00002130
C              BACK MULTIPLICATION.                                     00002140
C                                                                       00002150
               DO 130 I = LP1, P                                        00002160
                  V(I,L) = E(I)                                         00002170
  130          CONTINUE                                                 00002180
  140       CONTINUE                                                    00002190
  150    CONTINUE                                                       00002200
  160 CONTINUE                                                          00002210
  170 CONTINUE                                                          00002220
C                                                                       00002230
C     SET UP THE FINAL BIDIAGONAL MATRIX OR ORDER M.                    00002240
C                                                                       00002250
      M = MIN0(P,N+1)                                                   00002260
      NCTP1 = NCT + 1                                                   00002270
      NRTP1 = NRT + 1                                                   00002280
      IF (NCT .LT. P) S(NCTP1) = X(NCTP1,NCTP1)                         00002290
      IF (N .LT. M) S(M) = (0.0D0,0.0D0)                                00002300
      IF (NRTP1 .LT. M) E(NRTP1) = X(NRTP1,M)                           00002310
      E(M) = (0.0D0,0.0D0)                                              00002320
C                                                                       00002330
C     IF REQUIRED, GENERATE U.                                          00002340
C                                                                       00002350
      IF (.NOT.WANTU) GO TO 300                                         00002360
         IF (NCU .LT. NCTP1) GO TO 200                                  00002370
         DO 190 J = NCTP1, NCU                                          00002380
            DO 180 I = 1, N                                             00002390
               U(I,J) = (0.0D0,0.0D0)                                   00002400
  180       CONTINUE                                                    00002410
            U(J,J) = (1.0D0,0.0D0)                                      00002420
  190    CONTINUE                                                       00002430
  200    CONTINUE                                                       00002440
         IF (NCT .LT. 1) GO TO 290                                      00002450
         DO 280 LL = 1, NCT                                             00002460
            L = NCT - LL + 1                                            00002470
            IF (CABS1(S(L)) .EQ. 0.0D0) GO TO 250                       00002480
               LP1 = L + 1                                              00002490
               IF (NCU .LT. LP1) GO TO 220                              00002500
               DO 210 J = LP1, NCU                                      00002510
                  T = -ZDOTC(N-L+1,U(L,L),1,U(L,J),1)/U(L,L)            00002520
                  CALL ZAXPY(N-L+1,T,U(L,L),1,U(L,J),1)                 00002530
  210          CONTINUE                                                 00002540
  220          CONTINUE                                                 00002550
               CALL ZSCAL(N-L+1,(-1.0D0,0.0D0),U(L,L),1)                00002560
               U(L,L) = (1.0D0,0.0D0) + U(L,L)                          00002570
               LM1 = L - 1                                              00002580
               IF (LM1 .LT. 1) GO TO 240                                00002590
               DO 230 I = 1, LM1                                        00002600
                  U(I,L) = (0.0D0,0.0D0)                                00002610
  230          CONTINUE                                                 00002620
  240          CONTINUE                                                 00002630
            GO TO 270                                                   00002640
  250       CONTINUE                                                    00002650
               DO 260 I = 1, N                                          00002660
                  U(I,L) = (0.0D0,0.0D0)                                00002670
  260          CONTINUE                                                 00002680
               U(L,L) = (1.0D0,0.0D0)                                   00002690
  270       CONTINUE                                                    00002700
  280    CONTINUE                                                       00002710
  290    CONTINUE                                                       00002720
  300 CONTINUE                                                          00002730
C                                                                       00002740
C     IF IT IS REQUIRED, GENERATE V.                                    00002750
C                                                                       00002760
      IF (.NOT.WANTV) GO TO 350                                         00002770
         DO 340 LL = 1, P                                               00002780
            L = P - LL + 1                                              00002790
            LP1 = L + 1                                                 00002800
            IF (L .GT. NRT) GO TO 320                                   00002810
            IF (CABS1(E(L)) .EQ. 0.0D0) GO TO 320                       00002820
               DO 310 J = LP1, P                                        00002830
                  T = -ZDOTC(P-L,V(LP1,L),1,V(LP1,J),1)/V(LP1,L)        00002840
                  CALL ZAXPY(P-L,T,V(LP1,L),1,V(LP1,J),1)               00002850
  310          CONTINUE                                                 00002860
  320       CONTINUE                                                    00002870
            DO 330 I = 1, P                                             00002880
               V(I,L) = (0.0D0,0.0D0)                                   00002890
  330       CONTINUE                                                    00002900
            V(L,L) = (1.0D0,0.0D0)                                      00002910
  340    CONTINUE                                                       00002920
  350 CONTINUE                                                          00002930
C                                                                       00002940
C     TRANSFORM S AND E SO THAT THEY ARE DOUBLE PRECISION.              00002950
C                                                                       00002960
      DO 380 I = 1, M                                                   00002970
         IF (CABS1(S(I)) .EQ. 0.0D0) GO TO 360                          00002980
            T = DCMPLX(CDABS(S(I)),0.0D0)                               00002990
            R = S(I)/T                                                  00003000
            S(I) = T                                                    00003010
            IF (I .LT. M) E(I) = E(I)/R                                 00003020
            IF (WANTU) CALL ZSCAL(N,R,U(1,I),1)                         00003030
  360    CONTINUE                                                       00003040
C     ...EXIT                                                           00003050
         IF (I .EQ. M) GO TO 390                                        00003060
         IF (CABS1(E(I)) .EQ. 0.0D0) GO TO 370                          00003070
            T = DCMPLX(CDABS(E(I)),0.0D0)                               00003080
            R = T/E(I)                                                  00003090
            E(I) = T                                                    00003100
            S(I+1) = S(I+1)*R                                           00003110
            IF (WANTV) CALL ZSCAL(P,R,V(1,I+1),1)                       00003120
  370    CONTINUE                                                       00003130
  380 CONTINUE                                                          00003140
  390 CONTINUE                                                          00003150
C                                                                       00003160
C     MAIN ITERATION LOOP FOR THE SINGULAR VALUES.                      00003170
C                                                                       00003180
      MM = M                                                            00003190
      ITER = 0                                                          00003200
  400 CONTINUE                                                          00003210
C                                                                       00003220
C        QUIT IF ALL THE SINGULAR VALUES HAVE BEEN FOUND.               00003230
C                                                                       00003240
C     ...EXIT                                                           00003250
         IF (M .EQ. 0) GO TO 660                                        00003260
C                                                                       00003270
C        IF TOO MANY ITERATIONS HAVE BEEN PERFORMED, SET                00003280
C        FLAG AND RETURN.                                               00003290
C                                                                       00003300
         IF (ITER .LT. MAXIT) GO TO 410                                 00003310
            INFO = M                                                    00003320
C     ......EXIT                                                        00003330
            GO TO 660                                                   00003340
  410    CONTINUE                                                       00003350
C                                                                       00003360
C        THIS SECTION OF THE PROGRAM INSPECTS FOR                       00003370
C        NEGLIGIBLE ELEMENTS IN THE S AND E ARRAYS.  ON                 00003380
C        COMPLETION THE VARIABLES KASE AND L ARE SET AS FOLLOWS.        00003390
C                                                                       00003400
C           KASE = 1     IF S(M) AND E(L-1) ARE NEGLIGIBLE AND L.LT.M   00003410
C           KASE = 2     IF S(L) IS NEGLIGIBLE AND L.LT.M               00003420
C           KASE = 3     IF E(L-1) IS NEGLIGIBLE, L.LT.M, AND           00003430
C                        S(L), ..., S(M) ARE NOT NEGLIGIBLE (QR STEP).  00003440
C           KASE = 4     IF E(M-1) IS NEGLIGIBLE (CONVERGENCE).         00003450
C                                                                       00003460
         DO 430 LL = 1, M                                               00003470
            L = M - LL                                                  00003480
C        ...EXIT                                                        00003490
            IF (L .EQ. 0) GO TO 440                                     00003500
            TEST = CDABS(S(L)) + CDABS(S(L+1))                          00003510
            ZTEST = TEST + CDABS(E(L))                                  00003520
            IF (ZTEST .NE. TEST) GO TO 420                              00003530
               E(L) = (0.0D0,0.0D0)                                     00003540
C        ......EXIT                                                     00003550
               GO TO 440                                                00003560
  420       CONTINUE                                                    00003570
  430    CONTINUE                                                       00003580
  440    CONTINUE                                                       00003590
         IF (L .NE. M - 1) GO TO 450                                    00003600
            KASE = 4                                                    00003610
         GO TO 520                                                      00003620
  450    CONTINUE                                                       00003630
            LP1 = L + 1                                                 00003640
            MP1 = M + 1                                                 00003650
            DO 470 LLS = LP1, MP1                                       00003660
               LS = M - LLS + LP1                                       00003670
C           ...EXIT                                                     00003680
               IF (LS .EQ. L) GO TO 480                                 00003690
               TEST = 0.0D0                                             00003700
               IF (LS .NE. M) TEST = TEST + CDABS(E(LS))                00003710
               IF (LS .NE. L + 1) TEST = TEST + CDABS(E(LS-1))          00003720
               ZTEST = TEST + CDABS(S(LS))                              00003730
               IF (ZTEST .NE. TEST) GO TO 460                           00003740
                  S(LS) = (0.0D0,0.0D0)                                 00003750
C           ......EXIT                                                  00003760
                  GO TO 480                                             00003770
  460          CONTINUE                                                 00003780
  470       CONTINUE                                                    00003790
  480       CONTINUE                                                    00003800
            IF (LS .NE. L) GO TO 490                                    00003810
               KASE = 3                                                 00003820
            GO TO 510                                                   00003830
  490       CONTINUE                                                    00003840
            IF (LS .NE. M) GO TO 500                                    00003850
               KASE = 1                                                 00003860
            GO TO 510                                                   00003870
  500       CONTINUE                                                    00003880
               KASE = 2                                                 00003890
               L = LS                                                   00003900
  510       CONTINUE                                                    00003910
  520    CONTINUE                                                       00003920
         L = L + 1                                                      00003930
C                                                                       00003940
C        PERFORM THE TASK INDICATED BY KASE.                            00003950
C                                                                       00003960
         GO TO (530, 560, 580, 610), KASE                               00003970
C                                                                       00003980
C        DEFLATE NEGLIGIBLE S(M).                                       00003990
C                                                                       00004000
  530    CONTINUE                                                       00004010
            MM1 = M - 1                                                 00004020
            F = DREAL(E(M-1))                                           00004030
            E(M-1) = (0.0D0,0.0D0)                                      00004040
            DO 550 KK = L, MM1                                          00004050
               K = MM1 - KK + L                                         00004060
               T1 = DREAL(S(K))                                         00004070
               CALL DROTG(T1,F,CS,SN)                                   00004080
               S(K) = DCMPLX(T1,0.0D0)                                  00004090
               IF (K .EQ. L) GO TO 540                                  00004100
                  F = -SN*DREAL(E(K-1))                                 00004110
                  E(K-1) = CS*E(K-1)                                    00004120
  540          CONTINUE                                                 00004130
               IF (WANTV) CALL ZDROT(P,V(1,K),1,V(1,M),1,CS,SN)         00004140
  550       CONTINUE                                                    00004150
         GO TO 650                                                      00004160
C                                                                       00004170
C        SPLIT AT NEGLIGIBLE S(L).                                      00004180
C                                                                       00004190
  560    CONTINUE                                                       00004200
            F = DREAL(E(L-1))                                           00004210
            E(L-1) = (0.0D0,0.0D0)                                      00004220
            DO 570 K = L, M                                             00004230
               T1 = DREAL(S(K))                                         00004240
               CALL DROTG(T1,F,CS,SN)                                   00004250
               S(K) = DCMPLX(T1,0.0D0)                                  00004260
               F = -SN*DREAL(E(K))                                      00004270
               E(K) = CS*E(K)                                           00004280
               IF (WANTU) CALL ZDROT(N,U(1,K),1,U(1,L-1),1,CS,SN)       00004290
  570       CONTINUE                                                    00004300
         GO TO 650                                                      00004310
C                                                                       00004320
C        PERFORM ONE QR STEP.                                           00004330
C                                                                       00004340
  580    CONTINUE                                                       00004350
C                                                                       00004360
C           CALCULATE THE SHIFT.                                        00004370
C                                                                       00004380
            SCALE = DMAX1(CDABS(S(M)),CDABS(S(M-1)),CDABS(E(M-1)),      00004390
     *                    CDABS(S(L)),CDABS(E(L)))                      00004400
            SM = DREAL(S(M))/SCALE                                      00004410
            SMM1 = DREAL(S(M-1))/SCALE                                  00004420
            EMM1 = DREAL(E(M-1))/SCALE                                  00004430
            SL = DREAL(S(L))/SCALE                                      00004440
            EL = DREAL(E(L))/SCALE                                      00004450
            B = ((SMM1 + SM)*(SMM1 - SM) + EMM1**2)/2.0D0               00004460
            C = (SM*EMM1)**2                                            00004470
            SHIFT = 0.0D0                                               00004480
            IF (B .EQ. 0.0D0 .AND. C .EQ. 0.0D0) GO TO 590              00004490
               SHIFT = DSQRT(B**2+C)                                    00004500
               IF (B .LT. 0.0D0) SHIFT = -SHIFT                         00004510
               SHIFT = C/(B + SHIFT)                                    00004520
  590       CONTINUE                                                    00004530
            F = (SL + SM)*(SL - SM) - SHIFT                             00004540
            G = SL*EL                                                   00004550
C                                                                       00004560
C           CHASE ZEROS.                                                00004570
C                                                                       00004580
            MM1 = M - 1                                                 00004590
            DO 600 K = L, MM1                                           00004600
               CALL DROTG(F,G,CS,SN)                                    00004610
               IF (K .NE. L) E(K-1) = DCMPLX(F,0.0D0)                   00004620
               F = CS*DREAL(S(K)) + SN*DREAL(E(K))                      00004630
               E(K) = CS*E(K) - SN*S(K)                                 00004640
               G = SN*DREAL(S(K+1))                                     00004650
               S(K+1) = CS*S(K+1)                                       00004660
               IF (WANTV) CALL ZDROT(P,V(1,K),1,V(1,K+1),1,CS,SN)       00004670
               CALL DROTG(F,G,CS,SN)                                    00004680
               S(K) = DCMPLX(F,0.0D0)                                   00004690
               F = CS*DREAL(E(K)) + SN*DREAL(S(K+1))                    00004700
               S(K+1) = -SN*E(K) + CS*S(K+1)                            00004710
               G = SN*DREAL(E(K+1))                                     00004720
               E(K+1) = CS*E(K+1)                                       00004730
               IF (WANTU .AND. K .LT. N)                                00004740
     *            CALL ZDROT(N,U(1,K),1,U(1,K+1),1,CS,SN)               00004750
  600       CONTINUE                                                    00004760
            E(M-1) = DCMPLX(F,0.0D0)                                    00004770
            ITER = ITER + 1                                             00004780
         GO TO 650                                                      00004790
C                                                                       00004800
C        CONVERGENCE.                                                   00004810
C                                                                       00004820
  610    CONTINUE                                                       00004830
C                                                                       00004840
C           MAKE THE SINGULAR VALUE  POSITIVE                           00004850
C                                                                       00004860
            IF (DREAL(S(L)) .GE. 0.0D0) GO TO 620                       00004870
               S(L) = -S(L)                                             00004880
               IF (WANTV) CALL ZSCAL(P,(-1.0D0,0.0D0),V(1,L),1)         00004890
  620       CONTINUE                                                    00004900
C                                                                       00004910
C           ORDER THE SINGULAR VALUE.                                   00004920
C                                                                       00004930
  630       IF (L .EQ. MM) GO TO 640                                    00004940
C           ...EXIT                                                     00004950
               IF (DREAL(S(L)) .GE. DREAL(S(L+1))) GO TO 640            00004960
               T = S(L)                                                 00004970
               S(L) = S(L+1)                                            00004980
               S(L+1) = T                                               00004990
               IF (WANTV .AND. L .LT. P)                                00005000
     *            CALL ZSWAP(P,V(1,L),1,V(1,L+1),1)                     00005010
               IF (WANTU .AND. L .LT. N)                                00005020
     *            CALL ZSWAP(N,U(1,L),1,U(1,L+1),1)                     00005030
               L = L + 1                                                00005040
            GO TO 630                                                   00005050
  640       CONTINUE                                                    00005060
            ITER = 0                                                    00005070
            M = M - 1                                                   00005080
  650    CONTINUE                                                       00005090
      GO TO 400                                                         00005100
  660 CONTINUE                                                          00005110
      RETURN                                                            00005120
      END                                                               00005130
