*#**********************************************************************

      SUBROUTINE ZTRSL(T,LDT,N,B,JOB,INFO)                              00000010

      INTEGER LDT,N,JOB,INFO                                            00000020
      COMPLEX*16 T(LDT,1),B(1)                                          00000030
C                                                                       00000040
C                                                                       00000050
C     ZTRSL SOLVES SYSTEMS OF THE FORM                                  00000060
C                                                                       00000070
C                   T * X = B                                           00000080
C     OR                                                                00000090
C                   CTRANS(T) * X = B                                   00000100
C                                                                       00000110
C     WHERE T IS A TRIANGULAR MATRIX OF ORDER N. HERE CTRANS(T)         00000120
C     DENOTES THE CONJUGATE TRANSPOSE OF THE MATRIX T.                  00000130
C                                                                       00000140
C     ON ENTRY                                                          00000150
C                                                                       00000160
C         T         COMPLEX*16(LDT,N)                                   00000170
C                   T CONTAINS THE MATRIX OF THE SYSTEM. THE ZERO       00000180
C                   ELEMENTS OF THE MATRIX ARE NOT REFERENCED, AND      00000190
C                   THE CORRESPONDING ELEMENTS OF THE ARRAY CAN BE      00000200
C                   USED TO STORE OTHER INFORMATION.                    00000210
C                                                                       00000220
C         LDT       INTEGER                                             00000230
C                   LDT IS THE LEADING DIMENSION OF THE ARRAY T.        00000240
C                                                                       00000250
C         N         INTEGER                                             00000260
C                   N IS THE ORDER OF THE SYSTEM.                       00000270
C                                                                       00000280
C         B         COMPLEX*16(N).                                      00000290
C                   B CONTAINS THE RIGHT HAND SIDE OF THE SYSTEM.       00000300
C                                                                       00000310
C         JOB       INTEGER                                             00000320
C                   JOB SPECIFIES WHAT KIND OF SYSTEM IS TO BE SOLVED.  00000330
C                   IF JOB IS                                           00000340
C                                                                       00000350
C                        00   SOLVE T*X=B, T LOWER TRIANGULAR,          00000360
C                        01   SOLVE T*X=B, T UPPER TRIANGULAR,          00000370
C                        10   SOLVE CTRANS(T)*X=B, T LOWER TRIANGULAR,  00000380
C                        11   SOLVE CTRANS(T)*X=B, T UPPER TRIANGULAR.  00000390
C                                                                       00000400
C     ON RETURN                                                         00000410
C                                                                       00000420
C         B         B CONTAINS THE SOLUTION, IF INFO .EQ. 0.            00000430
C                   OTHERWISE B IS UNALTERED.                           00000440
C                                                                       00000450
C         INFO      INTEGER                                             00000460
C                   INFO CONTAINS ZERO IF THE SYSTEM IS NONSINGULAR.    00000470
C                   OTHERWISE INFO CONTAINS THE INDEX OF                00000480
C                   THE FIRST ZERO DIAGONAL ELEMENT OF T.               00000490
C                                                                       00000500
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000510
C     G. W. STEWART, UNIVERSITY OF MARYLAND, ARGONNE NATIONAL LAB.      00000520
C                                                                       00000530
C     SUBROUTINES AND FUNCTIONS                                         00000540
C                                                                       00000550
C     BLAS ZAXPY,ZDOTC                                                  00000560
C     FORTRAN DABS,DCONJG,MOD                                           00000570
C                                                                       00000580
C     INTERNAL VARIABLES                                                00000590
C                                                                       00000600
      COMPLEX*16 ZDOTC,TEMP                                             00000610
      INTEGER CASE,J,JJ                                                 00000620
C                                                                       00000630
      COMPLEX*16 ZDUM                                                   00000640
      DOUBLE PRECISION CABS1                                            00000650
      DOUBLE PRECISION DREAL,DIMAG                                      00000660
      COMPLEX*16 ZDUMR,ZDUMI                                            00000670
      DREAL(ZDUMR) = ZDUMR                                              00000680
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00000690
      CABS1(ZDUM) = DABS(DREAL(ZDUM)) + DABS(DIMAG(ZDUM))               00000700
C     BEGIN BLOCK PERMITTING ...EXITS TO 150                            00000710
C                                                                       00000720
C        CHECK FOR ZERO DIAGONAL ELEMENTS.                              00000730
C                                                                       00000740
         DO 10 INFO = 1, N                                              00000750
C     ......EXIT                                                        00000760
            IF (CABS1(T(INFO,INFO)) .EQ. 0.0D0) GO TO 150               00000770
   10    CONTINUE                                                       00000780
         INFO = 0                                                       00000790
C                                                                       00000800
C        DETERMINE THE TASK AND GO TO IT.                               00000810
C                                                                       00000820
         CASE = 1                                                       00000830
         IF (MOD(JOB,10) .NE. 0) CASE = 2                               00000840
         IF (MOD(JOB,100)/10 .NE. 0) CASE = CASE + 2                    00000850
         GO TO (20,50,80,110), CASE                                     00000860
C                                                                       00000870
C        SOLVE T*X=B FOR T LOWER TRIANGULAR                             00000880
C                                                                       00000890
   20    CONTINUE                                                       00000900
            B(1) = B(1)/T(1,1)                                          00000910
            IF (N .LT. 2) GO TO 40                                      00000920
            DO 30 J = 2, N                                              00000930
               TEMP = -B(J-1)                                           00000940
               CALL ZAXPY(N-J+1,TEMP,T(J,J-1),1,B(J),1)                 00000950
               B(J) = B(J)/T(J,J)                                       00000960
   30       CONTINUE                                                    00000970
   40       CONTINUE                                                    00000980
         GO TO 140                                                      00000990
C                                                                       00001000
C        SOLVE T*X=B FOR T UPPER TRIANGULAR.                            00001010
C                                                                       00001020
   50    CONTINUE                                                       00001030
            B(N) = B(N)/T(N,N)                                          00001040
            IF (N .LT. 2) GO TO 70                                      00001050
            DO 60 JJ = 2, N                                             00001060
               J = N - JJ + 1                                           00001070
               TEMP = -B(J+1)                                           00001080
               CALL ZAXPY(J,TEMP,T(1,J+1),1,B(1),1)                     00001090
               B(J) = B(J)/T(J,J)                                       00001100
   60       CONTINUE                                                    00001110
   70       CONTINUE                                                    00001120
         GO TO 140                                                      00001130
C                                                                       00001140
C        SOLVE CTRANS(T)*X=B FOR T LOWER TRIANGULAR.                    00001150
C                                                                       00001160
   80    CONTINUE                                                       00001170
            B(N) = B(N)/DCONJG(T(N,N))                                  00001180
            IF (N .LT. 2) GO TO 100                                     00001190
            DO 90 JJ = 2, N                                             00001200
               J = N - JJ + 1                                           00001210
               B(J) = B(J) - ZDOTC(JJ-1,T(J+1,J),1,B(J+1),1)            00001220
               B(J) = B(J)/DCONJG(T(J,J))                               00001230
   90       CONTINUE                                                    00001240
  100       CONTINUE                                                    00001250
         GO TO 140                                                      00001260
C                                                                       00001270
C        SOLVE CTRANS(T)*X=B FOR T UPPER TRIANGULAR.                    00001280
C                                                                       00001290
  110    CONTINUE                                                       00001300
            B(1) = B(1)/DCONJG(T(1,1))                                  00001310
            IF (N .LT. 2) GO TO 130                                     00001320
            DO 120 J = 2, N                                             00001330
               B(J) = B(J) - ZDOTC(J-1,T(1,J),1,B(1),1)                 00001340
               B(J) = B(J)/DCONJG(T(J,J))                               00001350
  120       CONTINUE                                                    00001360
  130       CONTINUE                                                    00001370
  140    CONTINUE                                                       00001380
  150 CONTINUE                                                          00001390
      RETURN                                                            00001400
      END                                                               00001410
