C*****  ACORF   Auto-Correlation (Freq-Domain)    MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL ACORF (A,C,N,M)
C
C       where,
C
C       A       Real input vector of length 2*M.
C
C       C       Real output vector.
C
C       N       Integer input element count for C,
C               number of lags.
C
C       M       Integer input element count for A.
C
C
C  DESCRIPTION
C
C       This routine performs an auto-correlation on a vector.
C       It performs the same operation as ACORT but, by using
C       an in-place FFT, runs faster for large vectors and large
C       number of lags (i.e., for large values of M and N).
C
C            C(j) = SUM[A(j+i-1)*A(i)]    for i=1,M-j+1 and j=1,N
C
C       M must be a power of two.
C
C       Although vector A has M elements, space for an additional
C       M elements must be allowed for performing the FFT.  At
C       the end of the operation, vector A is modified.
C
C
C  REFERENCE
C
C       E. O. Brigham.  1974.  The fast Fourier transform.
C       Englewood Cliffs NJ: Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL ACORF (A,C,6,8)
C
C       Input Operands:
C
C       A =   1.000
C             2.000
C             3.000
C             4.000
C             5.000
C             6.000
C             7.000
C             8.000
C           -99.000
C           -99.000
C           -99.000
C           -99.000
C           -99.000
C           -99.000
C           -99.000
C           -99.000
C
C       Output Operands:
C
C       C =  204.00
C            168.00
C            133.00
C            100.00
C             70.00
C             44.00
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C                       R. Coleman
C         2) Feb 88     L. Shanbeck     Use * for dummy dimension
C
      SUBROUTINE ACORF(A,C,N,M)
C
      REAL A(*),C(*)
      INTEGER N,M
      IF (N.LE.0 .OR. M.LE.0) GOTO 25
      CALL VCLR(A(M+1),1,M)
      CALL RFFT(A,M+M,1)
      A(1) = A(1) * A(1)
      A(2) = A(2) * A(2)
      CALL CVMAGS(A(3),2,A(3),2,M-1)
      CALL VCLR(A(4),2,M-1)
      CALL RFFTSC(A,M+M,0,-1)
      CALL RFFT(A,M+M,-1)
      CALL VMOV(A,1,C,1,N)
25    RETURN
      END
