C****** AMX010 INSORT   INDEXED INSERTION SORT ROUTINE      MTADV EXT    REL 1.0
C
C      ** COPYRIGHT 1988  QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C        CALL INSORT (A, INDEX, N )
C
C        where,
C
C        A        Real Input array of length N.  The array being sorted.
C
C        INDEX    Integer Input/Output array of length N.  The index table.
C                 Used as initial and final order.  If INDEX(1) is zero, then
C                 INDEX is intialized to consequtive integers from 1 to N.
C
C        N        Integer Input Scaler.  The length of each trace.
C
C  DESCRIPTION
C
C        This subroutine will apply the straight insertion algorithm to sort an
C        array into ascending order.  The array itself is unaltered.  Instead,
C        an index table is manipulated such that A(INDEX(j)) is in ascending
C        order for for j=1,N.   If INDEX(1) is nonzero the index array is used
C        to specify the initial order of the array.
C
C        The insertion algorithm for i=2,N sorts element i with the previous
C        elements.  This is a very inefficent, N**2 squared algorithm but is
C        useful for N less than 50.
C
C  REFERENCE
C
C        Press W. H., et. al., 1986, Numerical Recipes (Cambridge University
C        Press), chapter 8.
C
C  HISTORY
C        (1) MAY 88           T.G. Mattson           Original
C
C-----------------------------------------------------------------------
C
       SUBROUTINE AMX010 (A, INDEX, N)
       INTEGER N, INDEX(*), ITMP, I, J
       REAL    A(*), AA
C
C-----------------------------------------------------------------------
C
C  Initialize the index table if appropriate.
C
        IF( INDEX(1) .EQ. 0) THEN
            DO 100 I=1,N
                INDEX(I) = I
 100        CONTINUE
        ENDIF
C
        DO 120 J=2,N
C
C  Select an element to insert
C
           ITMP = INDEX(J)
           AA   = A(ITMP)
           DO 110 I = J-1,1,-1
C
C  Search all previous elements to find where to do the insertion.
C  Make room for the insertion while doing the search.
C
             IF ( A(INDEX(I)) .LE. AA) GO TO 10
             INDEX(I+1) = INDEX(I)
 110       CONTINUE
C
           I=0
 10        INDEX(I+1) = ITMP
 120    CONTINUE
C
        END
