C****** ATRMMM   MULTIPLE ALPHA TRIM MEAN              MTADV EXT    REL 1.0
C
C      ** COPYRIGHT 1988  QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C        CALL ATRMMM ( A,ISORT,ALPHA,ATM,N,NDIM,NTRC )
C
C        where,
C
C        A        Real input matrix of dimension NDIM by NTRC.  The first NTRC
C                 columns of A contain the traces to which the alpha trim mean
C                 operation will be applied.
C
C        ISORT    Integer work vector of length N,  used for the sorting.
C
C        ALPHA    Real input scaler.  ALPHA is used to define the half  width
C                 of the window around the median.   Values of ALPHA greater
C                 than one are treated as ALPHA equal to one.
C
C        ATM      Real output vector of length NTRC.  Contains the alpha trim
C                 mean for each trace.
C
C        N        Integer input scaler, length of each trace.
C
C        NDIM     Integer input scaler, trace dimension for A.  The beginnings
C                 of adjacent traces are separated by NDIM.
C
C        NTRC     Integer input scaler, number of traces in A.
C
C
C  DESCRIPTION
C
C        This routine will find the alpha trim mean for each trace in a set
C        of traces. The alpha trim mean is computed with a three step procedure.
C        First, the elements in the trace are sorted into ascending order.  Next
C        a window is placed about the middle of the sorted trace.  Finally, the
C        alpha trim mean is computed as the mean of the contents of the window.
C
C        The parameter ALPHA specifies the size of the window with the window's
C        half width given by the product of ALPHA and N/2.   An alpha value
C        of 0 results in an alpha trim mean equal to the median of the trace
C        while a  value of 1 yields the mean of the entire column as the alpha
C        trim mean. The median for an even number of points is defined as the
C        mean of the central two points.
C
C        The calculation of alpha trim means for  a collection of traces is
C        accelerated in this routine by careful management of the sorting.
C        Each sort routine returns its results through an index table displaying
C        the order of the sorted elements.   The first trace in the set is
C        sorted with a heap sort algorithm.   Subsequent traces are sorted with
C        a cruder algorithm using the index table from the previous trace as
C        the intial condition for the sort.  These crude sort algorithms
C        (straight insertion) are very efficient when applied to arrays that
C        are nearly ordered to begin with.   The succes of this procedure
C        depends on adjacent traces being similar to each other.  Note, the
C        sort algorithms used here are not partial sorts.
C
C        If N is less than or equal to zero, this routine immediately.
C
C  EXAMPLE
C
C        CALL ATRMMM ( A, ISORT, 0.30, ATM, 10, 10, 3)
C
C        Input Operands:
C
C         A    =    3.00       5.00        9.00
C                   2.00       0.00        7.00
C                   5.00       3.00        0.00
C                   4.00      -1.00       -1.00
C                   7.00      -4.00        1.00
C                   6.00       5.00        2.00
C                   9.00       4.00        7.00
C                   1.00      -2.00       -3.00
C                   2.00       4.00       -2.00
C                   7.00      -6.00       -8.00
C
C        Output Operands:
C
C         ATM  =    4.50       1.50        0.50E-01
C
C  SUBPROGRAMS USED
C
C        INTRINSICS:     NINT, ABS, FLOAT
C        OTHER:          AMX009, AMX010  - Heap and insertion sort subprograms
C
C  HISTORY
C        (1) MAY 88           T.G. Mattson           Original
C        (2) OCT 88           D.P. Madura            Added 'DO 110' loop
C
C-----------------------------------------------------------------------
C
       SUBROUTINE ATRMMM ( A, ISORT, ALPHA, ATM, N, NDIM, NTRC)
C
       INTEGER ISORT(*),  N, NDIM, NTRC
       REAL    A(NDIM,*), ALPHA, ATM(*)
       REAL    TATM, FNRECP, ABALPH
       INTEGER I,    ITRC, N2, IALPH, IND1, IND2, NVAL
C
C-----------------------------------------------------------------------
C
C  Test input parameters and handle case of N=1.
C
       IF ((N .LE. 0) .OR. (NDIM .LE. 0) .OR. (NTRC .LE. 0) )THEN
          RETURN
       ENDIF
       IF (N .EQ. 1) THEN
          DO 100 I=1,NTRC
            ATM(I) = A(1,I)
 100      CONTINUE
          RETURN
       ENDIF
C
C  Clear ISORT array
C
       DO 110 I = 1, N
          ISORT(I) = 0
 110   CONTINUE
C
C  Find window half width (IALPH).   If alpha = 1 find the mean for each trace.
C
       N2     = N/2
       ABALPH = ABS(ALPHA)
       IF( ABALPH .GT. 1) ABALPH = 1
       IALPH  = NINT ( ABALPH * FLOAT (N2) )
       FNRECP = 1.0/FLOAT(N)
       IF ( IALPH .EQ. N2) THEN
           DO 210 ITRC = 1,NTRC
              TATM = 0.0
              DO 205 I=1,N
                TATM = TATM + A(I,ITRC)
 205          CONTINUE
              ATM(ITRC) = TATM * FNRECP
 210       CONTINUE
           RETURN
       ENDIF
C
C  Find window limits, IND1 and IND2 and the window width, NVAL.
C
       IND1 = N2 + 1 - IALPH
       IF (2*N2 .EQ. N) THEN
          IF (IALPH .EQ. 0) THEN
             IND1  = N2
             NVAL  = 2
          ELSE
             NVAL  = IALPH * 2
          ENDIF
       ELSE
          NVAL = IALPH * 2 + 1
       ENDIF
       IND2 = IND1 + NVAL - 1
       FNRECP = 1.0/FLOAT(NVAL)
C
C  Sort the first trace, find its alpha trim mean and exit if done.  The
C  sort algorithm is a full Heap sort.
C
       CALL AMX009 ( A(1,1), ISORT, N)
       TATM = 0.0
       DO 300 I=IND1,IND2
          TATM = TATM + A(ISORT(I),1)
 300   CONTINUE
       ATM(1) = TATM * FNRECP
       IF (NTRC .EQ. 1)RETURN
C
C  Find the the alpha trim means of traces 2 through NTRC.  Sort with a
C  basic, straight insertion algorithm.
C
       DO 410 ITRC = 2,NTRC
          CALL AMX010 ( A(1,ITRC), ISORT, N)
          TATM = 0.0
          DO 400 I=IND1,IND2
             TATM = TATM + A(ISORT(I),ITRC)
 400      CONTINUE
          ATM(ITRC) = TATM * FNRECP
 410   CONTINUE
C
       RETURN
       END
