C*****  ATRMMN   ALPHA TRIM MEAN                        MTHADV EXT   REL 1.0
C
C      ** COPYRIGHT 1988  QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C        CALL ATRMMN ( A,ISORT,WORK,ALPHA,ATM,N)
C
C        where,
C
C        A        Real input vector of length N.
C
C        ISORT    Integer work vector of length N used for the sorting.
C
C        WORK     Real work vector of length N used for for sorting.
C
C        ALPHA    Real input scaler.  The absolute value of ALPHA is the
C                 fractional window half width for mean.  ALPHA values
C                 greater than one are treated as being equal to one.
C
C        ATM      Real output scaler. The alpha trim mean.
C
C        N        Integer input scaler. Length of the vector, A.
C
C  DESCRIPTION
C
C        This routine will compute the alpha trim mean of vector A.  To
C        compute the alpha trim mean, the data is sorted and the mean of a
C        window centered about the middle of the data is computed.   The
C        window's half width is the product of alpha and N/2.   An alpha value
C        of 0 results in an alpha trim mean equal to the median of the vector
C        A, while a  value of 1 yields the mean of A as the alpha trim mean.
C        The median for an even number of points is defined as the mean of
C        the central two points.
C
C        If N is less than or equal to zero, this routine immediately exits
C        without modifying any of the data.
C
C  EXAMPLE
C
C        CALL ATRMMN ( A, ISORT, WORK, 0.3, ATM, 8 )
C
C        Input Operands:
C           A = 10.0
C                4.0
C                7.0
C               12.0
C                2.0
C                4.0
C                1.0
C               14.0
C
C        Output Operands:
C           ATM = 5.5
C
C  SUBPROGRAMS USED:
C
C        INTRINSICS:     NINT, ABS, FLOAT
C        MATH ADVANTAGE: PSORT
C
C  HISTORY
C        (1) MAY 88           T.G. Mattson           Original
C
C-----------------------------------------------------------------------
      SUBROUTINE ATRMMN (A, ISORT, WORK, ALPHA, ATM, N)
C
      REAL    A(*), WORK(*), ALPHA, ATM, ABSAL
      INTEGER ISORT(*), N, N2, I, IND, IALPH, NVAL
C
C-----------------------------------------------------------------------
C
      IF (N .LE. 0) THEN
          RETURN
      ELSE IF (N .EQ. 1) THEN
          ATM = A(1)
          RETURN
      ENDIF
C
      ABSAL = ABS(ALPHA)
      IF (ABSAL .GT. 1) THEN
          ABSAL = 1
      ENDIF
      N2    = N/2
      IALPH = NINT (ABSAL * FLOAT (N2) )
      IF ( IALPH .EQ. N2) THEN
C
C  Compute the mean for the special case of ALPHA = 1.
C
          ATM = 0.0
          DO 100 I=1,N
             ATM = ATM + A(I)
 100      CONTINUE
          ATM = ATM / FLOAT(N)
          RETURN
      ENDIF
C
C  Compute beginning of the window and the window width.
C
      IND = N2 + 1 - IALPH
      IF (2*N2 .EQ. N) THEN
         IF (IALPH .EQ. 0) THEN
            IND  = N2
            NVAL = 2
         ELSE
            NVAL = IALPH * 2
         ENDIF
      ELSE
         NVAL = IALPH * 2 + 1
      ENDIF
C
C  Select the elements to be isolated with the sort and sort them.
C
      DO 200 I=1,NVAL
         ISORT(I) = IND
         IND      = IND + 1
  200 CONTINUE
      CALL PSORT (A, ISORT, WORK, N, NVAL )
C
C  Compute the alpha trim mean as the mean of the sorted array segment, work
C
      ATM = 0.0
      DO 300 I=1,NVAL
         ATM = ATM + WORK(I)
 300  CONTINUE
      ATM = ATM / FLOAT(NVAL)
C
  800 CONTINUE
      RETURN
      END
