C****** BWFILT  PASSBAND BUTTERWORTH FILTER APPLICATION      MTADV EXT REL 1.0
C
C      ** COPYRIGHT 1988  QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C        CALL BWFILT (X,Y,XD,YD,A,YNORM,NSECT,NSAMP,INIT,IFT)
C
C        where,
C
C        X        Real input vector of length NSAMP.  The input sequence to
C                 which the filter will be applied.
C
C        Y        Real output vector of length NSAMP.  The filtered X sequence.
C
C        XD       Real work vector of length 3.  Contains the delayed input
C                 samples.
C
C        YD       Real work vector of length 3*NSECT.  Contains the  delayed
C                 output samples for each section.
C
C        A        Real input matrix of dimension 2 by NSECT.  The filter
C                 coefficents (typically computed by BWCOEF).
C
C        YNORM    Real input scaler filter Normalization Constant.
C
C        NSECT    Integer input scaler.  The number of sections in the Cascade
C                 realization of the filter.  This is equal to the filter order
C                 for a Butterworth filter.
C
C        NSAMP    Integer input scaler, length of the sequences X and Y.
C
C        INIT     Integer input scaler. If greater than zero, the filter
C                 is initialized in this routine.
C
C        IFT      Integer input scaler.  For some applications, one may want
C                 this routine to add the value of the first element of the
C                 input trace to every element of the output trace.  If this is
C                 desired, set IFT to one.  All other values of IFT have are
C                 ignored.
C
C  DESCRIPTION
C
C        This routine applies a BUTTERWORTH filter to a trace.  The  filter
C        is realized as a cascade of NSECT second order structures;
C
C                  H(z)   =  H(1) * H(2) * ..... * H(i) *..... * H(NSECT)
C
C        where the individual structures are,
C
C                               K * (1 - z**2)
C                  H(i)   = ----------------------- .
C                             1 + D1 * z + D2 * z**2
C
C        The constant K assures that the overall filter has a normalized
C        frequency responce.   The K's for each section are combined to yield
C        the overall filter normalization constant called YNORM.  The filter
C        applied by this routine is synthesized in the routine, BWCOEF.
C
C        The filter must be initialized by setting the values in the delay
C        arrays, XD and YD.   The default initialization is done in this
C        routine if the flag INIT is set to a non-negative value.  This
C        initialization is:
C
C                         XD(n)   = X(1)    for  n = 1,3
C                         YD(n,i) = 0       for  n = 1,3 and  i = 1,NSECT
C
C        If other initializations are desired, the delay arrays can be set in
C        the calling program unit and INIT set to a negative value.
C
C        If NSECT or NSAMP are less than or equal to zero, this routine
C        returns immediately.
C
C  REFERENCE
C
C        Oppenheim A.V. and Schafer R.W., 1975, Digital Signal Processing,
C        (Englewood Cliffs, New Jersey, Prentice-Hall Co). Chapters 4 and 5.
C
C        Kanasewich E.R., Time Sequence Analysis in Geophysics.
C
C        This code is a direct modification of parts of the program FILT
C        written by R.B. Herrmann and T. Mokhtar of Saint Louis University
C        in 1986.
C
C  EXAMPLE
C
C        CALL BWFILT (X, Y, XD, YD, A, YNORM, 6, NSAMP, 1, IFT)
C
C        Input Operands:
C
C           X       =     0.0000000E+00
C                         1.884212
C                         3.763962
C                         5.634803
C                         7.492316
C                         9.332120
C                        11.14989
C                        12.94138
C                        14.70241
C                        16.42889
C
C           A       =    -2.00000000E+00      1.00000000E+00
C                        -2.00000000E+00      1.00000000E+00
C                        -2.00000000E+00      1.00000000E+00
C                        -9.04394269E-01      2.15528116E-01
C                        -1.01060855E+00      3.58282685E-01
C                        -1.26867843E+00      7.05134928E-01
C
C           YNORM   =     7.37701077E-04
C
C           IFT     =     1
C
C        Output Operands:
C
C           Y       =     0.00000000E+00
C                         1.38998521E-03
C                         1.55418618E-02
C                         8.47218484E-02
C                         3.03057313E-01
C                         8.08219790E-01
C                         1.73051167E+00
C                         3.12573600E+00
C                         4.93694639E+00
C                         7.01037931E+00
C
C  SUBPROGRAMS
C
C        None
C
C  HISTORY
C        (1) JUNE 88           T.G. Mattson           Original
C
C-----------------------------------------------------------------------
        SUBROUTINE BWFILT (X, Y, XD, YD, A, YNORM, NSECT, NSAMP,
     &                                              INIT, IFT)
C
        REAL    X(*), Y(*), XD(*), YD(3,*), A(2,*), YNORM
        INTEGER NSECT, NSAMP, INIT, I, J, JM1, IFT
        REAL    XTMP, XX0
C
C-----------------------------------------------------------------------
C
        IF ( (NSECT .LE. 0) .OR. (NSAMP .LE. 0) )THEN
           RETURN
        ENDIF
        IF (IFT .EQ. 1) THEN
           XX0 = X(1)
        ELSE
           XX0 = 0.0
        ENDIF
C
C  Initialize the DELAY array (if appropriate).
C
        IF ( INIT .GT. 0)THEN
           XTMP  = X(1)
           DO 150 I=1,3
              XD(I) = XTMP
              DO 100 J=1,NSECT
                 YD(I,J) = 0.0
 100          CONTINUE
 150       CONTINUE
        ENDIF
C
C  Apply the filter to the trace, X, using a cascade of second order
C  sections.   Each section takes its input from the previous section
C  with exception of the specially handled first section.  Note that the
C  delay array, YD, is updated as soon as its contents are used.
C
        DO 300 I = 1,NSAMP
           XD(1)   = X(I)
           YD(1,1) = XD(1) - XD(3) - A(1,1)*YD(2,1) - A(2,1)*YD(3,1)
           DO 200 J=2,NSECT
             JM1       = J - 1
             YD(1,J)   = YD(1,JM1) - YD(3,JM1) - A(1,J)*YD(2,J)
     &                                         - A(2,J)*YD(3,J)
             YD(3,JM1) = YD(2,JM1)
             YD(2,JM1) = YD(1,JM1)
 200       CONTINUE
C
C Finish updating the delay arrays
C
           XD(3)       = XD(2)
           XD(2)       = XD(1)
           YD(3,NSECT) = YD(2,NSECT)
           YD(2,NSECT) = YD(1,NSECT)
C
C Normalize and store the final, filtered sample
C
           Y(I)  = YNORM * YD(1,NSECT) + XX0
 300    CONTINUE
C
        RETURN
        END
