C*****  CHEAA  Complex Hermitian Eigenvalues & Eigenvectors  MATH ADV REL 3.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CHEAA(NM,N,A,W,Z,WRK,IERR)
C
C       where,
C
C       NM      Integer input number of rows in full matrices A and Z.
C
C       N       Integer input order of matrices A and Z.
C
C       A       Complex input matrix.
C
C       W       Real output vector of length N, eigenvalues.
C
C       Z       Complex output matrix, eigenvectors.
C
C       WRK     Real workspace vector of length 4*N.
C
C       IERR    Integer output completion code:
C                If IERR=0, the routine terminated normally.
C                If 1<=IERR<=N, the calculation of eigenvalue IERR
C                 failed to converge.  Eigenvalues 1 to IERR-1 are still
C                 valid; none of the eigenvectors are valid.
C
C  DESCRIPTION
C
C       This routine determines all eigenvalues and all eigenvectors
C       of complex Hermitian matrix A.
C
C       The eigenvectors are orthonormal.
C
C       On input, only the full lower triangle of matrix A need be
C       defined.  On output, the full lower triangle of matrix A is
C       altered; the strict upper triangle is unchanged.
C
C       This routine contains a subset of the EISPACK eigensystem
C       package developed by Argonne National Laboratory.  It uses the
C       EISPACK recommended path of HTRIDI-TQL2-HTRIBK.
C
C  REFERENCE
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C       J. H. Wilkinson.  1965.  The algebraic eigenvalue prob-
C       lem.  New York: Oxford University Press.
C
C
C  EXAMPLE
C
C       CALL CHEAA(3,3,A,W,Z,WRK,IERR)
C
C       Input Operands:
C
C       A = ( 1.0, 0.0)  ( 0.0, 0.0)  ( 0.0, 1.0)
C           ( 0.0, 0.0)  ( 1.0, 0.0)  ( 2.0, 1.0)
C           ( 0.0,-1.0)  ( 2.0,-1.0)  ( 5.0, 0.0)
C
C       Output Operands:
C
C       W =  6.162
C            1.000
C           -0.162
C
C       Z = ( 0.000, 0.194)  ( 1.000, 0.000)  ( 0.200, 0.400)
C           ( 0.387, 0.194)  (-0.200, 0.400)  ( 1.000, 0.000)
C           ( 1.000, 0.000)  ( 0.000, 0.000)  (-0.465, 0.232)
C
C       IERR = 0
C
C       Note concerning output values:
C
C       The eigenvalues (array W) may be arranged in any order; and the
C       rows of the eigenvectors (matrix Z) are associated with a particular
C       eigenvalue and will be ordered correspondingly.  Also, the eigen-
C       vectors may be multiplied by a constant and still be correct
C       (i.e., orthonormal vectors).
C
C  HISTORY
C         1) Sep 86     L. Tarvestad    Original.
C
      SUBROUTINE CHEAA(NM,N,A,W,Z,WRK,IERR)
      INTEGER I,J,N,NM,IERR
      REAL A(1),W(1),Z(1),WRK(1)
C
      IF (N.LE.0 .OR. N.GT.NM) GO TO 50
      CALL  QTC040(NM,N,A,W,WRK,WRK(1+N),WRK(1+N+N))
      DO 40 J = 1, N
         DO 30 I = 1, N
            Z(2*NM*(J-1)+2*I-1) = 0.0
30       CONTINUE
         Z(2*NM*(J-1)+2*J-1) = 1.0
40    CONTINUE
C
      CALL  QTC043(NM,N,W,WRK,Z,IERR)
      IF (IERR .NE. 0) GO TO 50
      CALL  QTC039(NM,N,A,WRK(1+N+N),N,Z)
50    RETURN
      END
