C*****  CMESSV  Complex Envelope Solve            MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CMESSV (S,ICP,N,NS,BX,M)
C
C       where,
C
C       S       Complex input vector of length NS.
C               S contains a superposition of the L' and D
C               factors of A.
C
C       ICP     Integer input vector of column pointers of length N+1.
C
C       N       Integer input  order of matrix A.
C
C       NS      Integer input element count of vector S.
C
C       BX      Complex input/output matrix of dimension N by M.
C               On input, BX contains M right-hand sides.
C               On output, BX contains M solution vectors.
C
C       M       Integer input number of right-hand sides.
C
C
C  DESCRIPTION
C
C       This routine solves a complex linear system Ax = b,
C       where A has been factored into LDL' by CMESFC, and is
C       represented in envelope format by S and ICP.
C
C
C  REFERENCE
C
C       J. H. Wilkinson.  1965.  The algebraic eigenvalue prob-
C       lem.  New York: Oxford University Press.
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C       D. Young.  1971.  Iterative solution of large linear
C       systems.  New York: Academic Press.
C
C       D. J. Evans (ed).  1985.  Sparsity and its applica-
C       tions.  New York: Cambridge University Press.
C
C
C  EXAMPLE
C
C       CALL CMESSV (S,ICP,6,11,BX,2)
C
C       Input Operands:
C
C       S =  ( 0.041,-0.049)        ICP = 1
C            ( 0.056,-0.145)              2
C            ( 0.057, 0.131)              4
C            ( 0.068, 0.055)              7
C            (-0.064, 0.069)              8
C            (-0.025,-0.270)             11
C            ( 0.000,-0.500)             12
C            (-0.034,-0.085)
C            ( 0.000, 0.000)
C            ( 0.123,-0.012)
C            ( 0.000,-0.250)
C
C       BX = ( 28.0, 37.0)    ( 10.0,-27.0)
C            ( 15.0,-60.0)    (-37.0, 24.0)
C            ( 88.0,-68.0)    ( 87.0,-29.0)
C            ( -8.0, -6.0)    ( 12.0, -8.0)
C            (-40.0,-64.0)    ( 54.0,-22.0)
C            (  0.0, 16.0)    (  8.0,-12.0)
C
C       Output Operands:
C
C       BX = ( 3.0, 4.0)    (-1.0, 0.0)
C            (-8.0,-7.0)    ( 2.0, 7.0)
C            ( 9.0,-1.0)    ( 8.0, 4.0)
C            (-3.0, 4.0)    (-4.0,-6.0)
C            (-3.0, 6.0)    (-3.0,-3.0)
C            ( 4.0, 0.0)    (-3.0,-2.0)
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C                       R. Coleman
C
      SUBROUTINE CMESSV(S,ICP,N,NS,BX,M)
C
      INTEGER M,N,NS,ICP(1)
      REAL    S(1), BX(1),SUMR,SUMI,TEMPR
      INTEGER I,J,K,K1,K2,IM,L,II,N2
C
      IF (N.LE.0 .OR. NS.LE.0 .OR. M.LE.0) GOTO 900
      N2 = N+N
      DO 800 L = 2,M*N2,N2
C
      IF (N .GT. 1) GOTO 50
        IM = ICP(1)*2
        TEMPR = BX(L-1) * S(IM-1) - BX(L) * S(IM)
        BX(L) = BX(L-1) * S(IM) + BX(L) * S(IM-1)
        BX(L-1) = TEMPR
        GOTO 800
50    CONTINUE
C
C     FORWARD ELIMINATION
C
      II = L
      DO 220 J = 2, N
         K1 = ICP(J  ) + 1
         K2 = ICP(J+1) - 1
         II = II + 2
         IF (K1 .GT. K2) GO TO 220
         I = II
         SUMR = 0.0
         SUMI = 0.0
         DO 210 K = K1+K1, K2+K2, 2
            I = I - 2
            SUMR = SUMR + S(K-1) * BX(I-1) - S(K) * BX(I)
            SUMI = SUMI + S(K-1) * BX(I) + S(K) * BX(I-1)
  210    CONTINUE
         BX(II-1) = BX(II-1) - SUMR
         BX(II)   = BX(II) - SUMI
  220 CONTINUE
C
C     SCALING
C
      II = L
      DO 230 I = 1, N
         IM = ICP(I)*2
         TEMPR = BX(II-1) * S(IM-1) - BX(II) * S(IM)
         BX(II)   = BX(II-1) * S(IM) + BX(II) * S(IM-1)
         BX(II-1) = TEMPR
         II = II+2
  230 CONTINUE
C
C     BACKWARD SUBSTITUTION
C
      II = L + N2
      DO 250 J = N, 2, -1
         K1 = ICP(J  ) + 1
         K2 = ICP(J+1) - 1
         II = II - 2
         IF (K1 .GT. K2) GO TO 250
         I = II
         DO 240 K = K1+K1, K2+K2, 2
            I = I - 2
            TEMPR = BX(I-1) - (S(K-1) * BX(II-1) - S(K) * BX(II))
            BX(I) = BX(I) - (S(K-1) * BX(II) + S(K) * BX(II-1))
            BX(I-1) = TEMPR
  240    CONTINUE
  250 CONTINUE
800   CONTINUE
C
900   RETURN
      END
