C*****  CMFUFS  Complex Full Factor and Solve       MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CMFUFS (A,NRA,N,B,NRB,M,ZTOL,IPERM,X,NRX,IERR)
C
C       where,
C
C       A       Complex input/output matrix.  On input, A contains
C               the matrix to be factored and solved.  On output,
C               A contains the factored form.
C
C       NRA     Integer input number of rows in full matrix A.
C
C       N       Integer input order of submatrix A.
C
C       B       Complex input matrix containing M right-hand sides.
C
C       NRB     Integer input number of rows in full matrix B.
C
C       M       Integer input number of right-hand sides.
C
C       ZTOL    Real input scalar, pivot zero tolerance.
C
C       IPERM   Integer output permutation vector of length N.
C
C       X       Complex output matrix containing M solution vectors.
C
C       NRX     Integer input number of rows in full matrix X.
C
C       IERR    Integer output completion code:
C                   =0 if the routine terminated normally.
C                   >0 if the routine aborted because a pivot
C                      was less than or equal to ZTOL.
C                      This implies the matrix is singular.
C                      The value of IERR is the index of the column
C                      where it aborted.
C
C
C  DESCRIPTION
C
C       This routine solves the complex linear system Ax=b by calling
C       CMFUFC to factor the complex matrix A into LU form.   It then
C       calls CMFUSV to solve the system.
C
C
C  REFERENCE
C
C       J. H. Wilkinson.  1965.  The algebraic eigenvalue prob-
C       lem.  New York: Oxford University Press.
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C
C  EXAMPLE
C
C       CALL CMFUFS (A,3,3,B,3,2,ZTOL,IPERM,X,3,IERR)
C
C       Input Operands:
C
C       A = (1.000,1.000)  (0.000,0.000)  ( 1.000, 5.000)
C           (1.000,2.000)  (3.000,1.000)  (-1.000,18.000)
C           (0.000,0.000)  (2.000,3.000)  (-6.000, 8.000)
C
C       B = ( -32.000, 36.000)   ( -52.000, 76.000)
C           (-134.000,102.000)   (-220.000,230.000)
C           ( -94.000, 12.000)   (-171.000, 57.000)
C
C       ZTOL = 1.0E-5
C
C       Output Operands:
C
C       A = (0.200,-0.400)  ( 1.000,-1.000)  ( 7.000,4.000)
C           (0.000, 0.000)  ( 0.154,-0.231)  ( 0.923,2.615)
C           (1.000, 1.000)  (-2.000, 0.000)  (-0.250,1.250)
C
C       IPERM = 2
C               3
C               1
C
C       X = (1.000,3.000)  ( 6.000, 8.000)
C           (2.000,4.000)  ( 9.000,11.000)
C           (5.000,7.000)  (10.000,12.000)
C
C       IERR = 0
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C                       R. Coleman
C         2) Jan 88     L. Shanbeck     Expanded IERR functionality
C
      SUBROUTINE CMFUFS(A,NRA,N,B,NRB,M,ZTOL,IPERM,X,NRX,IERR)
C
      INTEGER NRA,NRB,M,N,IERR,IPERM(1),NRX
      REAL    A(1),B(1),X(1),ZTOL
C
C   *******************************************************************
C
      IERR = 0
      IF (M.LE.0 .OR. N.LE.0 .OR. NRA.LT.N .OR. NRB.LT.N .OR. NRX.LT.N)
     +   GOTO 900
      CALL CMFUFC(A,NRA,N,ZTOL,IPERM,IERR)
      IF (IERR .NE. 0) GOTO 900
      CALL CMFUSV(A,NRA,N,B,NRB,M,IPERM,X,NRX)
900   RETURN
      END
