C*****  CMSSFC  Complex Symmetric Sparse Factor   MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CMSSFC (S,IRN,ICP,N,NS,ZTOL,IERR)
C
C       where,
C
C       S       Complex input/output vector of length NS.
C               On input, S contains the elements of the
C               complex matrix A stored in sparse symmetric
C               format.  On output, S contains a superposition
C               of the L and D factors.
C
C       IRN     Integer input vector of length NS containing
C               the row number of each element stored in vector S.
C
C       ICP     Integer input vector of column pointers of length
C               N+1.
C
C       N       Integer input order of matrix A.
C
C       NS      Integer input element count of vector S.
C
C       ZTOL    Real input scalar, diagonal element zero tolerance.
C
C       IERR    Integer output completion code:
C                   =0 if the routine terminated normally.
C                   >0 if the routine aborted because a diagonal
C                      element was less than or equal to ZTOL.
C                      The value of IERR is the index of the column
C                      where it aborted.
C
C
C  DESCRIPTION
C
C       This routine factors a complex sparse symmetric matrix A,
C       represented in sparse, symmetric format by the vectors S,
C       IRN, and ICP into LDL' form.
C
C       D is a diagonal matrix.  L is a lower triangular matrix that
C       has all 1's on its diagonal.  L' is the transpose of L.
C       L and the reciprocated elements of D are overlaid on S.
C       L' is not stored.
C
C       This routine does not do pivoting.  Therefore, the
C       matrix A should be numerically stable in the form in which
C       it is input.
C
C
C  REFERENCE
C
C       D. Young.  1971.  Iterative solution of large linear
C       systems.  New York: Academic Press.
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C       D. J. Evans (ed).  1985.  Sparsity and its applica-
C       tions.  New York: Cambridge University Press.
C
C
C  EXAMPLE
C
C       CALL CMSSFC (S,IRN,ICP,6,14,ZTOL,IERR)
C
C       Input Operands:
C
C       S = (10.0,12.0)       IRN = 1   ICP = 1
C           (-1.0, 2.0)             2         5
C           ( 3.0,-3.0)             3         8
C           ( 1.0, 0.0)             6        11
C           ( 2.0, 6.0)             2        12
C           (-1.0, 1.0)             3        14
C           ( 0.0, 0.0)  (Fill-in)  6        15
C           ( 8.0,-8.0)             3
C           ( 1.0,-1.0)             5
C           ( 0.0, 0.0)  (Fill-in)  6
C           ( 0.0, 2.0)             4
C           (-4.0,10.0)             5
C           ( 0.0, 0.0)  (Fill-in)  6
C           ( 0.0, 4.0)             6
C
C       ZTOL = 1.0E-5
C
C       Output Operands:
C
C       S = ( 0.041,-0.049)
C           ( 0.057, 0.131)
C           (-0.025,-0.270)
C           ( 0.041,-0.049)
C           ( 0.056,-0.145)
C           ( 0.025, 0.270)
C           (-0.022, 0.001)  (Fill-in)
C           ( 0.070, 0.053)
C           ( 0.123,-0.017)
C           (-0.016, 0.020)  (Fill-in)
C           ( 0.000,-0.500)
C           (-0.034,-0.085)
C           (-0.003, 0.002)  (Fill-in)
C           (-0.002,-0.247)
C
C       IERR = 0
C
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C                       R. Coleman
C         2) Aug 85     D. Cooper       ECR 8/6/85--fixed potential
C                                       infinite loop at statement 20.
C         3) Jan 88     L. Shanbeck     Expanded IERR functionality
C
      SUBROUTINE CMSSFC(S,IRN,ICP,N,NS,ZTOL,IERR)
C
      INTEGER N,NS,IERR,J,L0,L1,L2,L,I,K,K2
      REAL S(1),ZTOL,ZTOLSQ,YR,YI,TMP,TR,TI,XR,XI
      INTEGER ICP(1), IRN(1)
      IF (N.LE.0 .OR. NS.LE.0) GO TO 90
      L2 = 1
      ZTOLSQ = ZTOL*ZTOL
      DO 60 J = 1, N
         L1 = L2
         L2 = ICP(J+1)
         YR =   S(L1+L1-1)
         YI = - S(L1+L1)
         TMP = YR * YR + YI * YI
         IF(TMP .LE. ZTOLSQ) GO TO 91
         TMP = 1.0 / TMP
         TR = TMP * YR
         TI = TMP * YI
         S(L1+L1-1) = TR
         S(L1+L1) = TI
         IF(J .EQ. N) GO TO 60
         L1 = L1 + 1
         IF(L1 .GE. L2) GO TO 60
         DO 40 L0 = L1, L2-1
            YR = S(L0+L0-1)
            YI = S(L0+L0)
            IF(YR .EQ. 0.0 .AND. YI .EQ. 0.0) GO TO 40
            XR = TR * YR - TI * YI
            XI = TR * YI + TI * YR
            K = ICP(IRN(L0)) - 1
            DO 30 L = L0, L2-1
               I = IRN(L)
 20            CONTINUE
               K = K + 1
               IF(K .GT. NS) GOTO 90
               IF(IRN(K) .NE. I) GO TO 20
               YR = S(L+L-1)
               YI = S(L+L)
               K2 = K + K
               S(K2-1) = S(K2-1) - XR * YR + XI * YI
               S(K2) = S(K2) - XR * YI - XI * YR
 30         CONTINUE
 40      CONTINUE
 60   CONTINUE
C
      IF (N.LT.2) GOTO 90
      L2 = ICP(1)*2
      DO 80 J = 1, N-1
         L1 = L2
         L2 = ICP(J+1)
         L2 = L2 + L2
         TR = S(L1-1)
         TI = S(L1)
         L1 = L1 + 2
         IF(L1 .GE. L2) GO TO 80
         DO 70 L = L1, L2-2, 2
            YR = S(L-1)
            YI = S(L)
            S(L-1) = TR * YR - TI * YI
            S(L) = TR * YI + TI * YR
 70      CONTINUE
 80   CONTINUE
C
90    IERR = 0
      GOTO 900
C
91    IERR = J
C
900   RETURN
      END
