C*****  CMSSFS  Complex Symmetric Sparse Factor and Solve   MATH ADV REL 2.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CMSSFS (S,IRN,ICP,N,NS,ZTOL,BX,M,IERR)
C
C       where,
C
C       S       Complex input/output vector of length NS.
C               On input, S contains the elements of the
C               complex matrix A stored in sparse symmetric
C               format.  On output, S contains a superposition
C               of the L and D factors.
C
C       IRN     Integer input vector of length NS containing
C               the row number of each element stored in S.
C
C       ICP     Integer input vector of column pointers of length
C               N+1.
C
C       N       Integer input order of matrix A.
C
C       NS      Integer input element count of vector S.
C
C       ZTOL    Real input scalar, diagonal element zero tolerance.
C
C       BX      Complex input/output matrix of dimension N by M.
C               On input, BX contains M right-hand sides.
C               On output, BX contains M solution vectors.
C
C       M       Integer input number of right-hand sides.
C
C       IERR    Integer output completion code:
C                   =0 if the routine terminated normally.
C                   >0 if the routine aborted because a diagonal
C                      element was less than or equal to ZTOL.
C                      The value of IERR is the index of the column
C                      where it aborted.
C
C
C  DESCRIPTION
C
C       This routine solves the complex linear system Ax = b by calling
C       CMSSFC to factor the complex symmetric matrix A into LDL'
C       form.  It then calls CMSSSV to solve the system.
C
C
C  REFERENCE
C
C       D. Young.  1971.  Iterative solution of large linear
C       systems.  New York: Academic Press.
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C       D. J. Evans (ed).  1985.  Sparsity and its applica-
C       tions.  New York: Cambridge University Press.
C
C
C  EXAMPLE
C
C       CALL CMSSFS (S,IRN,ICP,6,14,ZTOL,BX,2,IERR)
C
C       Input Operands:
C
C       S = (10.0,12.0)      IRN = 1   ICP = 1
C           (-1.0, 2.0)            2         5
C           ( 3.0,-3.0)            3         8
C           ( 1.0, 0.0)            6        11
C           ( 2.0, 6.0)            2        12
C           (-1.0, 1.0)            3        14
C           ( 0.0, 0.0) (Fill-in)  6        15
C           ( 8.0,-8.0)            3
C           ( 1.0,-1.0)            5
C           ( 0.0, 0.0) (Fill-in)  6
C           ( 0.0, 2.0)            4
C           (-4.0,10.0)            5
C           ( 0.0, 0.0) (Fill-in)  6
C           ( 0.0, 4.0)            6
C
C       BX = ( 32.0, 37.0)    (  7.0,-29.0)
C            (  7.0,-50.0)    (-49.0, 28.0)
C            (103.0,-69.0)    ( 78.0,-34.0)
C            ( -8.0, -6.0)    ( 12.0, -8.0)
C            (-40.0,-64.0)    ( 54.0,-22.0)
C            (  3.0, 20.0)    (  7.0,-12.0)
C
C       ZTOL = 1.0E-5
C
C       Output Operands:
C
C       S = ( 0.041,-0.049)
C           ( 0.057, 0.131)
C           (-0.025,-0.270)
C           ( 0.041,-0.049)
C           ( 0.056,-0.145)
C           ( 0.025, 0.270)
C           (-0.022, 0.001)  (Fill-in)
C           ( 0.070, 0.053)
C           ( 0.123,-0.017)
C           (-0.016, 0.020)  (Fill-in)
C           ( 0.000,-0.500)
C           (-0.034,-0.085)
C           (-0.003, 0.002)  (Fill-in)
C           (-0.002,-0.247)
C
C       BX = ( 3.0, 4.0)      (-1.0, 0.0)
C            (-8.0,-7.0)      ( 2.0, 7.0)
C            ( 9.0,-1.0)      ( 8.0, 4.0)
C            (-3.0, 4.0)      (-4.0,-6.0)
C            (-3.0, 6.0)      (-3.0,-3.0)
C            ( 4.0, 0.0)      (-3.0,-2.0)
C
C       IERR = 0
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C                       R. Coleman
C         2) Jan 88     L. Shanbeck     Expanded IERR functionality
C
      SUBROUTINE CMSSFS(S,IRN,ICP,N,NS,ZTOL,BX,M,IERR)
C
      INTEGER M,N, NS, ICP(1), IRN(1), IERR
      REAL S(1), ZTOL, BX(1)
C
      IERR = 0
      IF (M.LE.0 .OR. N.LE.0 .OR. NS.LE.0) GOTO 900
      CALL CMSSFC(S,IRN,ICP,N,NS,ZTOL,IERR)
      IF(IERR .NE. 0) GOTO 900
      CALL CMSSSV(S,IRN,ICP,N,NS,BX,M)
900   RETURN
      END
