C*****  CMSSSV  Complex Symmetric Sparse Solve       MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CMSSSV (S,IRN,ICP,N,NS,BX,M)
C
C       where,
C
C       S       Complex input vector of length NS.  S
C               contains a superposition of the L and D
C               factors of A.
C
C       IRN     Integer input vector of length NS containing
C               the row number of each element stored in S.
C
C       ICP     Integer input vector of column pointers of length
C               N+1.
C
C       N       Integer input order of matrix A.
C
C       NS      Integer input element count of vector S.
C
C       BX      Complex input/output matrix of dimension N by M.
C               On input, BX contains M right-hand sides.
C               On output, BX contains M solution vectors.
C
C       M       Integer input number of right-hand sides.
C
C
C  DESCRIPTION
C
C       This routine solves a complex linear system Ax = b,
C       where A has been factored into LDL' form using CMSSFC,
C       and is represented in sparse symmetric format by S,
C       IRN, and ICP.
C
C
C  REFERENCE
C
C       D. Young.  1971.  Iterative solution of large linear
C       systems.  New York: Academic Press.
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C       D. J. Evans (ed).  1985.  Sparsity and its applica-
C       tions.  New York: Cambridge University Press.
C
C
C  EXAMPLE
C
C       CALL CMSSSV (S,IRN,ICP,6,14,BX,2)
C
C       Input Operands:
C
C       S = ( 0.041,-0.049)   IRN = 1   ICP = 1
C           ( 0.057, 0.131)         2         5
C           (-0.025,-0.270)         3         8
C           ( 0.041,-0.049)         6        11
C           ( 0.056,-0.145)         2        12
C           ( 0.025, 0.270)         3        14
C           (-0.022, 0.001)         6        15
C           ( 0.070, 0.053)         3
C           ( 0.123,-0.017)         5
C           (-0.016, 0.020)         6
C           ( 0.000,-0.500)         4
C           (-0.034,-0.085)         5
C           (-0.003,-0.002)         6
C           (-0.002,-0.247)         6
C
C       BX = ( 32.0, 37.0)    (  7.0,-29.0)
C            (  7.0,-50.0)    (-49.0, 28.0)
C            (103.0,-69.0)    ( 78.0,-34.0)
C            ( -8.0, -6.0)    ( 12.0, -8.0)
C            (-40.0,-64.0)    ( 54.0,-22.0)
C            (  3.0, 20.0)    (  7.0,-12.0)
C
C
C       Output Operands:
C
C       BX = ( 3.0, 4.0)       (-1.0, 0.0)
C            (-8.0,-7.0)       ( 2.0, 7.0)
C            ( 9.0,-1.0)       ( 8.0, 4.0)
C            (-3.0, 4.0)       (-4.0,-6.0)
C            (-3.0, 6.0)       (-3.0,-3.0)
C            ( 4.0, 0.0)       (-3.0,-2.0)
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C                       R. Coleman
C
      SUBROUTINE CMSSSV(S,IRN,ICP,N,NS,BX,M)
C
      INTEGER M,N,NS,NM1,I,J,K,L1,L2,IPTR,IPT2,L,LM1
      REAL BX(1), S(1), TMPR, TMPI, BXR, BXI
      INTEGER ICP(1), IRN(1)
      IF (N.LE.0 .OR. NS.LE.0 .OR. M.LE.0) GOTO 900
C
      DO 850 L = 1,M*(N+N),N+N
        LM1 = L - 1
C       FORWARD ELIMINATION
        IF (N.EQ.1) GOTO 21
        NM1=N-1
        DO 20 J=1,NM1
C  ANNIHILATE JTH COLUMN BELOW DIAGONAL
          L1=ICP(J)+1
          L2=ICP(J+1)-1
          IF (L1.GT.L2) GO TO 20
C ----    TMP=BX(J)
          IPTR = J + J + LM1
          TMPR = BX(IPTR-1)
          TMPI = BX(IPTR)
C ----    IF (CABS(TMP).EQ.0.0) GO TO 20
          IF (TMPR .EQ. 0.0 .AND. TMPI .EQ. 0.0) GOTO 20
          DO 10 I=L1,L2
              IPTR = IRN(I)*2 + LM1
C ----        BX(IRN(I))=BX(IRN(I))-TMP*S(I)
              BX(IPTR-1) = BX(IPTR-1) - (TMPR*S(I+I-1) - TMPI*S(I+I))
              BX(IPTR)   = BX(IPTR) - (TMPR*S(I+I) + TMPI*S(I+I-1))
10        CONTINUE
20      CONTINUE
C       FIND Y(J)
21      DO 30 J=1,N
          IPTR = ICP(J)*2
          IPT2 = J + J + LM1
C ----    BX(J)=S(ICP(J))*BX(J)
          BXR = S(IPTR-1)*BX(IPT2-1) - S(IPTR)*BX(IPT2)
          BXI = S(IPTR-1)*BX(IPT2) + S(IPTR)*BX(IPT2-1)
          BX(IPT2-1)   = BXR
          BX(IPT2)     = BXI
30      CONTINUE
C  BACKWARD SUBSTITUTION
        IF (N.EQ.1) GOTO 850
        DO 50 K=2,N
          J=N-K+1
C  ANNIHILATE JTH COLUMN ABOVE DIAGONAL
          L1=ICP(J)+1
          L2=ICP(J+1)-1
          IF (L1.GT.L2) GO TO 50
C ----    TMP=BX(J)
          IPT2 = J + J + LM1
          TMPR = BX(IPT2-1)
          TMPI = BX(IPT2)
          DO 40 I=L1,L2
              IPTR = IRN(I)*2 + LM1
C ----        TMP=TMP-BX(IRN(I))*S(I)
              TMPR = TMPR - (BX(IPTR-1)*S(I+I-1) - BX(IPTR)*S(I+I))
              TMPI = TMPI - (BX(IPTR-1)*S(I+I) + BX(IPTR)*S(I+I-1))
40        CONTINUE
C ----    BX(J) = TMP
          BX(IPT2-1) = TMPR
          BX(IPT2) = TMPI
50      CONTINUE
850   CONTINUE
900   RETURN
      END
