C*****  COHER   Coherence Function                MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL COHER (A,B,C,D,N)
C
C       where,
C
C       A       Real input vector, auto-spectrum.
C
C       B       Real input vector, auto-spectrum.
C
C       C       Complex input vector, cross-spectrum.
C
C       D       Real output vector.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine computes the coherence function of the two
C       signals given their auto-spectra (A and B) and the cross-
C       spectrum between them (C).  The results are stored in D.
C
C            D(i) = [real(C(i))**2 + imag(C(i))**2] / (A(i)*B(i))
C            for i=1,N
C
C
C  REFERENCE
C
C       P. Bloomfield.  1976.  Fourier analysis of time series:
C       an introduction.  New York: Wiley & Sons.
C
C
C  EXAMPLE
C
C       CALL COHER (A,B,C,D,5)
C
C       Input Operands:
C
C       A =    6.000
C             27.000
C             64.000
C            117.000
C            186.000
C
C       B =  182.00
C            115.00
C             64.00
C             29.00
C             10.00
C
C       C =  (29.0,-11.0)
C            (54.0,-11.0)
C            (63.0,-11.0)
C            (56.0,-11.0)
C            (33.0,-11.0)
C
C       Output Operands:
C
C       D =  0.881
C            0.978
C            0.999
C            0.960
C            0.650
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE COHER(A,B,C,D,N)
C
      INTEGER N,KK,M
      REAL A(1),B(1),C(1),D(1)
      IF (N.LE.0) GO TO 12
      KK = 1
      DO 10 M=1,N
        D(M) = (C(KK) * C(KK) + C(KK+1) * C(KK+1)) / (A(M) * B(M))
        KK = KK+2
10    CONTINUE
12    RETURN
      END
