C*****  CVADD   Complex Vector Add                MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CVADD (A,IA,B,IB,C,IC,N)
C
C       where,
C
C       A       Complex input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Complex input vector.
C
C       IB      Integer input stride for vector B.
C
C       C       Complex output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine adds the elements of two complex vectors
C       A and B and stores the results in complex vector C.
C
C            real(C(i)) = real(A(i)) + real(B(i))
C            imag(C(i)) = imag(A(i)) + imag(B(i))    for i=1,N
C
C
C  REFERENCE
C
C       J. H. Matthews.  1982.  Basic complex variables for
C       mathematics and engineering.  New York: Allyn and
C       Bacon.
C
C
C  EXAMPLE
C
C       CALL CVADD (A,2,B,2,C,2,2)
C
C       Input Operands:
C
C       A =  (1.000,2.000)
C            (3.000,4.000)
C
C       B = (10.000,20.000)
C           (30.000,40.000)
C
C       Output Operands:
C
C       C = (11.000,22.000)
C           (33.000,44.000)
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE CVADD(A,IA,B,IB,C,IC,N)
C
      INTEGER IA,IB,IC,N,II,JJ,KK,M
      REAL A(1),B(1),C(1)
      IF (N.LE.0) GO TO 40
      II = 1
      JJ = 1
      KK = 1
      DO 10 M=1,N
        C(KK) = A(II) + B(JJ)
        C(KK+1) = A(II+1) + B(JJ+1)
        II = II+IA
        JJ = JJ+IB
        KK = KK+IC
10    CONTINUE
40    RETURN
      END
