C*****   CVCSML  COMPLEX VECTOR COMPLEX SCALER MULTIPLICATION MTHADV EXT REL 1.0
C
C      ** COPYRIGHT 1988  QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C        CALL CVCSML (A,IA,B,C,IC,N)
C
C        where,
C
C        A        Complex input vector of length N.
C
C        IA       Integer input stride for A.
C
C        B        Complex input scaler multiplier.
C
C        C        Complex output vector of length N.
C
C        IC       Integer input stride for C.
C
C        N        Integer input number of elements in A and C.
C
C  DESCRIPTION
C
C        This routine finds the product of the input complex scaler with
C        the input complex vector:
C
C            REAL(C(i))  = REAL(A(i)) * REAL(B)  -  IMAG(A(i)) * IMAG(B)
C            IMAG(C(i))  = REAL(A(i)) * IMAG(B)  +  IMAG(A(i)) * REAL(B)
C
C        for i=1,N.
C
C  EXAMPLE
C
C        CALL CVCSML (A, 1, B, C, 1, 3)
C
C        Input Operands:
C
C              A = (1.000, 2.000)
C                  (2.000, 1.000)
C                  (3.000, 3.000)
C
C              B = (2.000, 1.000)
C
C        Output Operands:
C
C              C = (0.000,5.000)
C                  (3.000,4.000)
C                  (3.000,9.000)
C
C  HISTORY
C        (1) APR 88           T.G. Mattson           Original
C
C-----------------------------------------------------------------------
      SUBROUTINE CVCSML (A, IA, B, C, IC, N)
C
      REAL    A(*), B(2), C(*)
      INTEGER IA,   IC,   N
      REAL    AR,   AI,   BR,  BI
      INTEGER J,    JA,   JC
C
C-----------------------------------------------------------------------
C
      IF (N .LE. 0) GO TO 800
C
      BR = B(1)
      BI = B(2)
      JA = 1
      JC = 1
      DO 110 J = 1, N
         AR      = A(JA)
         AI      = A(JA+1)
         C(JC  ) = AR * BR - AI * BI
         C(JC+1) = AR * BI + AI * BR
         JA      = JA + IA
         JC      = JC + IC
  110 CONTINUE
C
  800 CONTINUE
      RETURN
      END
