C*****  CVFILL  Complex Vector Fill               MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CVFILL (A,C,IC,N)
C
C       where,
C
C       A       Complex input scalar.
C
C       C       Complex output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine fills the elements of a complex vector C
C       with complex constant A.
C
C            real(C(i)) = real(A)
C            imag(C(i)) = imag(A)    for i=1,N
C
C
C  REFERENCE
C
C       J. H. Matthews.  1982.  Basic complex variables for
C       mathematics and engineering.  New York: Allyn and
C       Bacon.
C
C
C  EXAMPLE
C
C       CALL CVFILL (A,C,2,3)
C
C       Input Operands:
C
C       A = (1.000,2.000)
C
C       Output Operands:
C
C       C = (1.000,2.000)
C           (1.000,2.000)
C           (1.000,2.000)
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE CVFILL(A,C,IC,N)
C
      INTEGER IC,N,KK,M
      REAL A(1),C(1)
      IF (N.LE.0) GO TO 12
      KK = 1
      DO 10 M=1,N
        C(KK) = A(1)
        C(KK+1) = A(2)
        KK = KK+IC
10    CONTINUE
12    RETURN
      END
