C*****  CVMAGS  Complex Vector Magnitude Squared  MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CVMAGS (A,IA,C,IC,N)
C
C       where,
C
C       A       Complex input vector.
C
C       IA      Integer input stride for vector A.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine computes the sum of the squares of the
C       real and imaginary parts of each element of a
C       complex vector A and stores the results in real
C       vector C.
C
C            C(i) = real(A(i))**2 + imag(A(i))**2   for i=1,N
C
C
C  REFERENCE
C
C       J. H. Matthews.  1982.  Basic complex variables for
C       mathematics and engineering.  New York: Allyn and
C       Bacon.
C
C
C  EXAMPLE
C
C       CALL CVMAGS (A,2,C,1,2)
C
C       Input Operands:
C
C       A = ( 1.000,-2.000)
C           (-3.000, 4.000)
C
C       Output Operands:
C
C       C =  5.000
C           25.000
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE CVMAGS(A,IA,C,IC,N)
C
      INTEGER IA,IC,N,II,KK,M
      REAL A(1),C(1)
      IF (N.LE.0) GO TO 12
      II = 1
      KK = 1
      DO 10 M=1,N
        C(KK) = A(II)*A(II) + A(II+1)*A(II+1)
        II = II+IA
        KK = KK+IC
10    CONTINUE
12    RETURN
      END
