C*****  CVMEXP  Complex Vector Multiply Expntl    MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CVMEXP (A,IA,B,IB,C,IC,N)
C
C       where,
C
C       A       Real input vector, in radians.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input vector.
C
C       IB      Integer input stride for vector B.
C
C       C       Complex output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine computes the complex exponential of a
C       vector A, and multiplies it by a real vector B.
C
C            real(C(i)) = B(i) * COS(A(i))
C            imag(C(i)) = B(i) * SIN(A(i))    for i=1,N
C
C
C  REFERENCE
C
C       J. H. Matthews.  1982.  Basic complex variables for
C       mathematics and engineering.  New York: Allyn and
C       Bacon.
C
C
C  EXAMPLE
C
C       CALL CVMEXP (A,1,B,1,C,2,2)
C
C       Input Operands:
C
C       A =  0.785
C           -0.785
C
C       B =  1.414
C            2.828
C
C       Output Operands:
C
C       C = (1.000, 1.000)
C           (2.000,-2.000)
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE CVMEXP(A,IA,B,IB,C,IC,N)
C
      INTEGER IA,IB,IC,N,II,JJ,KK,M
      REAL A(1),B(1),C(1)
      IF (N.LE.0) GO TO 40
      II = 1
      JJ = 1
      KK = 1
      DO 10 M=1,N
        C(KK) = B(JJ) * COS(A(II))
        C(KK+1) = B(JJ) * SIN(A(II))
        II = II+IA
        JJ = JJ+IB
        KK = KK+IC
10    CONTINUE
40    RETURN
      END
