C*****  CVSQRT   Complex Vector Square Root    MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CVSQRT (A,IA,C,IC,N)
C
C       where,
C
C       A       Complex input vector.
C
C       IA      Integer input stride for vector A.
C
C       C       Complex output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine computes square root of the elements
C       of complex input vector A.  The results are stored
C       in complex vector C.
C
C       real(C(i)) = R * COS(THETA)
C       imag(C(i)) = R * SIN(THETA)        for i = 1,N
C
C       where,
C       R = SQRT(SQRT(real(A(i))**2 + imag(A(i))**2))
C       THETA = ATAN2(imag(A(i)), real(A(i))) / 2.0
C
C  REFERENCE
C
C       J. H. Matthews.  1982.  Basic complex variables for
C       mathematics and engineering.  New York: Allyn and
C       Bacon.
C
C
C  EXAMPLE
C
C       CALL CVSQRT (A,2,C,2,3)
C
C       Input Operands:
C
C       A =  (1.000,2.000)
C            (3.000,4.000)
C            (5.000,6.000)
C
C       Output Operands:
C
C       C = (1.272, 0.786)
C           (2.000, 1.000)
C           (2.531, 1.185)
C
C  HISTORY
C         1) Jul 86     D. Benua         Original.
C
      SUBROUTINE CVSQRT(A,IA,C,IC,N)
C
      INTEGER IA,IC,N,II,KK,M
      REAL A(1),C(1),R,THETA
      IF (N.LE.0) GO TO 40
      II = 1
      KK = 1
      DO 10 M=1,N
        IF (A(II).NE.0.0 .OR. A(II+1).NE.0.0) GOTO 6
           C(KK) = 0.0
           C(KK+1) = 0.0
           GOTO 8
6       THETA = ATAN2( A(II+1), A(II) )
        R = SQRT( A(II)**2 + A(II+1)**2 )
        THETA = THETA / 2.0
        R = SQRT( R )
        C(KK)= R * COS( THETA )
        C(KK+1) = R * SIN( THETA )
8       II = II + IA
        KK = KK + IC
10    CONTINUE
40    RETURN
      END
