C***** DAGCAB  DIGITAL AUTOMATIC GAIN CONTROL, ABSOLUTE  MTHADV EXT  REL 1.0
C
C   ** COPYRIGHT 1988  QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL DAGCAB( A, G, N, LW, AMP )
C
C       where
C
C       A       Real input vector of input data trace.
C
C       G       Real output vector of gain trace.
C
C       N       Integer input number of elements in vectors A and G.
C
C       LW      Integer input length of window used to calculate gains.
C               LW must be odd.
C
C       AMP     Real input scalar that defines the desired level to maintain.
C
C
C  DESCRIPTION:
C
C       This routine computes a gain trace for a digital automatic gain
C       control. A window of length LW is moved through the data vector to
C       calculate the gain vector. The elements of the vector are computed
C       by:
C
C               G(i) = AMP * LW / SUM( A(j) )
C
C               For i = 1,N
C
C               where  SUM( A(j) ) = the sum of LW values of A centered
C                      about the i'th element of A.
C
C       Special calculations for the gain are done for the starting and
C       ending values.
C
C       If LW is not odd, the routine will return without updating G.
C
C
C
C  REFERENCES:
C
C       NONE
C
C
C  EXAMPLE:
C
C       CALL DAGCAB( A, G, 10, 3, 15.0 )
C
C       INPUT OPERANDS:
C
C       A  =      0.0
C                10.0
C                20.0
C                10.0
C                 0.0
C               -10.0
C               -20.0
C               -10.0
C                 0.0
C                 9.0
C
C
C       OUTPUT OPERANDS:
C
C       G  =    2.99996996
C               1.49999499
C               1.12499714
C               1.49999487
C               2.24998832
C               1.49999487
C               1.12499714
C               1.49999487
C               2.36840820
C               3.33329511
C
C
C  SUBPROGRAMS:
C
C       INTRINSICS:     ABS
C
C
C  HISTORY:
C       1) May 1988          P. G. Crose                          Original
C
C----------------------------------------------------------------------------
C
        SUBROUTINE DAGCAB( A, G, N, LW, AMP )
C
        REAL A(*), G(*), AMP
        INTEGER N, LW
C
        REAL SUM, FACT
        REAL DUM1, DUM2
        INTEGER I, ISTA, ISTO, J, K, LWD2, LWD2P1, IFACT
        REAL TOLZ
c        PARAMETER ( TOLZ = 1.0E-10 )
c I am changing tolz to be 1.e-20 to be compatible with libut....Garossino
 
        PARAMETER ( TOLZ = 1.0E-20 )
C
C----------------------------------------------------------------------------
C
C
c        SUM = 0.0001
c the above sum set is causing erroneous scaling on datasets with small
c magnitude samples.  I am getting rid of it as I can't see any reason for it
c the same changes have been made in the ut library.....Garossino
        SUM = 0.0
        LWD2 = LW/2
C       test for LW odd
        IF ( LWD2 + LWD2 .EQ. LW ) RETURN
        ISTO = LWD2 + 1
        DO 1 I = 1, ISTO
            SUM = SUM + ABS( A(I) )
  1     CONTINUE
        IF ( SUM .GT. TOLZ ) THEN
                G(1) = ISTO * AMP / SUM
        ELSE
                G(1) = 0.0
        ENDIF
C
        DO 2 I = 2, ISTO
                J = LWD2 + I
                SUM = SUM + ABS( A( J ) )
                IF ( SUM .GT. TOLZ ) THEN
                    G(I) = FLOAT(J) * AMP / SUM
                ELSE
                    G(I) = 0.0
                ENDIF
  2     CONTINUE
C
        ISTA = ISTO + 1
        ISTO = N - LWD2
        LWD2P1 = LWD2 + 1
        FACT = AMP * FLOAT( LW )
C
        DO 3 I = ISTA, ISTO
                J = I - LWD2P1
                K = I + LWD2
                DUM1 = A( K )
                DUM2 = A( J )
                SUM = SUM + ABS( DUM1 ) - ABS( DUM2 )
                    IF ( SUM .GT. TOLZ ) THEN
                        G(I) = FACT / SUM
                    ELSE
                        G(I) = 0.0
                    ENDIF
  3     CONTINUE
C
        ISTA = ISTO + 1
        IFACT = LW + ISTA - 1
C
        DO 4 I = ISTA, N
                J = I - LWD2P1
                SUM = SUM - ABS( A(J) )
                IF ( SUM .GT. TOLZ ) THEN
                    G(I) = FLOAT( IFACT - I ) * AMP / SUM
                ELSE
                    G(I) = 0.0
                ENDIF
  4     CONTINUE
C
        RETURN
        END
