C*****  DASUM    Sum of Magnitudes of Double Prec Reals     MATH ADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       DW = DASUM (N,DX,INCX)
C
C       where,
C
C       N       Integer input element count.
C
C       DX      Double precision real input vector.
C
C       INCX    Integer input stride for vector DX.
C               May not be negative.
C
C
C  DESCRIPTION
C
C       This function returns the sum of the absolute values of the
C       elements of double precision vector DX.
C
C               DASUM = sum (DABS(DX(i))       for i=1,N
C
C  REFERENCE
C
C       J.J. Dongarra and C.B. Moler, J.R. Bunch, G.W. Stewart.  1979.
C       LINPACK Users' Guide.  Appendix A: Basic Linear Algebra Subprograms.
C       SIAM
C
C
C  EXAMPLE
C
C       DW = DASUM (5,DX,1)
C
C       Input Operands:
C
C       DX =  1.000
C             2.000
C            -3.000
C             4.000
C             5.000
C
C       Output Result:
C
C       DW = 15.0
C
C  HISTORY
C         1) Jan 88     L. Shanbeck     Original.
C
C
      DOUBLE PRECISION FUNCTION DASUM(N,DX,INCX)
      DOUBLE PRECISION DX(1)
      INTEGER N,INCX,I,NS
C
      DASUM = 0.0D0
      IF(N.LE.0 .OR. INCX .LT. 0) GO TO 999
C
      NS = N*INCX
      DO 10 I = 1,NS,INCX
        DASUM = DASUM + DABS(DX(I))
   10 CONTINUE
999   RETURN
      END
