C*****  DCOPY    Double Precision Real Vector Copy     MATH ADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL DCOPY (N,DX,INCX,DY,INCY)
C
C       where,
C
C       N       Integer input element count.
C
C       DX      Double precision real input vector.
C
C       INCX    Integer input stride for vector DX.
C
C       DY      Double precision real output vector.
C
C       INCY    Integer input stride for vector DY.
C
C
C  DESCRIPTION
C
C       This routine copies the elements of a double precision real
C       vector DX into the elements of another double precision real
C       vector DY.
C
C                  DY(i) = DX(i)           for i=1,N
C
C  REFERENCE
C
C       J.J. Dongarra and C.B. Moler, J.R. Bunch, G.W. Stewart.  1979.
C       LINPACK Users' Guide.  Appendix A: Basic Linear Algebra Subprograms.
C       SIAM
C
C
C  EXAMPLE
C
C       CALL DCOPY (2,DX,1,DY,1)
C
C       Input Operands:
C
C       DX =  1.000
C             3.000
C
C       Output Operands:
C
C       DY =  1.000
C             3.000
C
C  HISTORY
C         1) Jan 88     L. Shanbeck     Original.
C
C
      SUBROUTINE DCOPY(N,DX,INCX,DY,INCY)
C
      DOUBLE PRECISION DX(1),DY(1)
      INTEGER N,INCX,INCY,II,KK,M
C
      IF (N.LE.0) GO TO 40
      II = 1
      KK = 1
      IF (INCX.LT.0) II = (1-N)*INCX + 1
      IF (INCY.LT.0) KK = (1-N)*INCY + 1
      DO 10 M=1,N
        DY(KK) = DX(II)
        II = II+INCX
        KK = KK+INCY
10    CONTINUE
40    RETURN
      END
