C*****  DEQ22   Difference Eq'n, 2 Poles, 2 0s    MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL DEQ22 (A,IA,B,C,IC,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input vector, five filter
C               coefficients.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine performs a two-pole, two-zero (second-order)
C       difference equation on a vector A.
C
C       The filter coefficients are stored in vector B and the
C       results of the routine are stored in real vector C.  The
C       first two elements of the source vector A (i.e., A(1) and
C       A(2), if stride IA = 1) must contain the two initial
C       conditions for A.  The two initial conditions for
C       the destination vector C must be stored as the first
C       two elements of C (i.e., C(1) and C(2),  if stride
C       IC = 1).
C
C       To leave room for the two initial conditions,
C       both vector A and C must be of length N + 2.
C
C            C(i) = B(1)*A(i) + B(2)*A(i-1) + B(3)*A(i-2) -
C                   B(4)*C(i-1) - B(5)*C(i-2)   for i=3,N+2
C
C       DEQ22 can be used to do an IIR filter (Infinite Impulse Response).
C       See CONV for FIR filter (Finite Impulse Response).
C
C
C  REFERENCE
C
C       L. R. Rabiner and B. Gold.  1975.  Theory and applica-
C       tion of digital signal processing.  Englewood Cliffs
C       NJ: Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL DEQ22 (A,1,B,C,1,3)
C
C       Input Operands:
C
C       A = 1.000
C           2.000
C           3.000
C           4.000
C           5.000
C
C       B = 3.000
C           2.000
C           1.000
C          -1.000
C          -2.000
C
C       C = 8.000
C           7.000
C         -99.000
C         -99.000
C         -99.000
C
C       Output Operands:
C
C       C = 8.000
C           7.000
C          37.000
C          71.000
C         171.000
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE DEQ22(A,IA,B,C,IC,N)
C
      INTEGER IA,IC,N,II,KK,M,K2,I2
      REAL A(1),B(1),C(1)
      IF (N.LE.0) GO TO 12
      K2 = IC + IC
      I2 = IA + IA
      II = 1 + I2
      KK = 1 + K2
      DO 10 M=1,N
        C(KK) = B(1)*A(II) + B(2)*A(II-IA) + B(3)*A(II-I2)
     1             - B(4)*C(KK-IC) - B(5)*C(KK-K2)
        II = II+IA
        KK = KK+IC
10    CONTINUE
12    RETURN
      END
