C*****  DSCAL  Dbl Prec Scalar Times a Dbl Prec Vector      MATH ADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL DSCAL (N,DA,DX,INCX)
C
C       where,
C
C       N       Integer input element count.
C
C       DA      Double precision real input scalar.
C
C       DX      Double precision real input vector.
C
C       INCX    Integer input stride for vector DX.
C               May not be negative.
C
C
C  DESCRIPTION
C
C       This routine multiplies the elements of a double precision
C       real vector DX by a double precision real scalar DA.
C
C       DX(i) = DA * DX(i)               for i=1,N
C
C  REFERENCE
C
C       J.J. Dongarra and C.B. Moler, J.R. Bunch, G.W. Stewart.  1979.
C       LINPACK Users' Guide.  Appendix A: Basic Linear Algebra Subprograms.
C       SIAM
C
C
C  EXAMPLE
C
C       CALL DSCAL (2,DA,DX,1)
C
C       Input Operands:
C
C       DA =  2.000
C
C       DX =  1.000
C            -3.000
C
C       Output Operands:
C
C       DX =  2.000
C            -6.000
C
C  HISTORY
C         1) Jan 88     L. Shanbeck     Original.
C
C
      SUBROUTINE DSCAL(N,DA,DX,INCX)
C
      DOUBLE PRECISION DA,DX(1)
      INTEGER N,INCX,NS,M
C
      IF (N.LE.0 .OR. INCX.LT.0) GO TO 40
      NS = N*INCX
      DO 10 M=1,NS,INCX
        DX(M) = DA*DX(M)
10    CONTINUE
40    RETURN
      END
