C*****  FLNZ   First and Last Non-Zero Position      MTHADV EXT. REL 1.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL FLNZ (A,IA,LF,LL,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       LF      Integer output scalar, first non-zero displacement.
C
C       LL      Integer output scalar, last non-zero displacement.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine finds the displacement of the first and
C       last non-zero elements of the input vector A encountered
C       in a scan of N elements selected by stride IA.
C       Displacement is the value that would be added to the
C       subscript of the element of A referenced in the subroutine
C       call.
C
C
C
C  EXAMPLE
C
C       CALL FLNZ (A,1,LF,LL,5)
C
C       Input Operands:
C
C       A =  0.000
C           -1.000
C            0.000
C            1.000
C            2.000
C
C
C       Output Operands:
C
C       LF = 1
C
C       LL = 4
C
C
C  HISTORY
C         1) Jul 86     D. Benua        Original.
C
C-----------------------------------------------------------------------
C
      SUBROUTINE FLNZ(A,IA,LF,LL,N)
C
      INTEGER IA,LF,LL,N,M,IFOUN,II
      REAL A(1)
C
C-----------------------------------------------------------------------
C
      IF (N.LE.0) GO TO 12
      II = 1
      IFOUN = 0
      DO 10 M=1,N
         IF (A(II) .EQ. 0.0) GOTO 8
            IF (IFOUN .EQ. 1)  GOTO 6
               IFOUN = 1
               LF = II - 1
6           LL = II - 1
8        II = II + IA
10    CONTINUE
12    RETURN
      END
