C*****  FNORM2 Euclidian Norm Function, no Scaling   MTHADV EXT. REL 1.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       Y = FNORM2 (N,X,INCX)
C
C       where,
C
C       Y       Real output function value.
C
C       N       Integer input element count.
C
C       X       Real input vector.
C
C       INCX    Integer input stride for vector X.
C
C
C  DESCRIPTION
C
C       This real function computes the Euclidean norm of vector X.
C
C       Y = SQRT( X(1)**2 + X(2)**2 + ... X(n)**2 )
C
C       FNORM2 is equivalent to function FNRM2, except that no scaling
C       is done to avoid destructive underflow or overflow.
C
C       FNORM2 should only be used when the values in vector X conform
C       to one of the following conditions.
C
C         1) CUTLO < abs(X(i)) < CUTHI/N   for i=1,n
C
C                    where CUTLO = SQRT(U/EPS)
C                          CUTHI = SQRT(V)
C                          EPS = smallest value where 1.0+EPS>1.0
C                          U   = smallest representable pos. value
C                          V   = largest representable value
C
C         2) X(i)=0.0   for i=1,N
C
C       If it is not known that one of these conditions is always met,
C       function FNRM2 should be used instead.
C
C  EXAMPLE
C
C       Y = FNORM2 (4,X,1)
C
C       Input Operands:
C
C       X = 1.0
C           2.0
C           3.0
C           4.0
C
C       Output Operands:
C
C       Y = 5.48
C
C
C  HISTORY
C         1) Dec 86     L. Tarvestad    Original.
C
C-----------------------------------------------------------------------
C
      REAL FUNCTION FNORM2(N,X,INCX)
C
      INTEGER N,INCX,II,M
      REAL X(1),SUM
C
C-----------------------------------------------------------------------
C
      IF (N.GT.0) GO TO 10
        FNORM2 = 0.0
        GO TO 300
C
10    SUM = 0.0
      II = 1
      DO 12 M = 1,N
        SUM = SUM + X(II)**2
        II = II + INCX
12    CONTINUE
      FNORM2 = SQRT(SUM)
300   RETURN
      END
