C*****  GRAD2D  Maximum Gradient Filter           MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL GRAD2D (A,NRA,IRA,ICA,C,NRC,IRC,ICC,NRAA,NCAA)
C
C       where,
C
C       A       Real input matrix.
C
C       NRA     Integer input number of rows in full matrix A.
C
C       IRA     Integer input initial row of the submatrix of A.
C
C       ICA     Integer input initial column of the submatrix of A.
C
C       C       Real output matrix.
C
C       NRC     Integer input number of rows in full matrix C.
C
C       IRC     Integer input initial row of the submatrix of C.
C
C       ICC     Integer input initial column of the submatrix of C.
C
C       NRAA    Integer input number of rows in submatrix A.
C
C       NCAA    Integer input number of columns in submatrix A.
C
C
C  DESCRIPTION
C
C       This routine filters images for edge enhancement by
C       applying a spatial gradient operator to emphasize
C       regions of rapid level change.
C
C       This routine does not check that only data within full matrix A
C       is read.  This means you should be careful when choosing values
C       of submatrix pointers and dimensions, to make sure data outside
C       of A is not used.
C
C            CC(i,j) = MAX{ABS[AA(i-1,j-1) + AA(i-1,j) +  AA(i-1,j+1)
C                      - AA(i+1,j-1) - AA(i+1,j) - AA(i+1,j+1)],
C                      ABS[AA(i-1,j-1) + AA(i,j-1) + AA(i+1,j-1)
C                      - AA(i-1,j+1) - AA(i,j+1) - AA(i+1,j+1)]}
C                      for i=1,NRAA and j=1,NCAA
C
C       where,
C
C            CC and AA are the submatrices of C and A
C
C       The gradient is the maximum of the absolute value of the two 3x3
C       convolution operations with the two following operator matrices:
C
C          +1 0 -1           +1 +1 +1
C          +1 0 -1   and      0  0  0
C          +1 0 -1           -1 -1 -1
C
C
C  REFERENCE
C
C       A. Rosenfeld and A. C. Kak.  1976.  Digital signal pro-
C       cessing.  New York: Academic Press.
C
C
C  EXAMPLE
C
C       CALL GRAD2D (A,8,2,2,C,8,2,2,6,5)
C
C       Input Operands:
C
C       A = 0.00  0.00  0.00  0.00  0.00  0.00  0.00
C           0.00  1.00  1.00  1.00  1.00  1.00  0.00
C           0.00  1.00  1.00  1.00  1.00  1.00  0.00
C           0.00  1.00  2.00  3.00  2.00  1.00  0.00
C           0.00  1.00  2.00  3.00  2.00  1.00  0.00
C           0.00  1.00  1.00  1.00  1.00  1.00  0.00
C           0.00  1.00  1.00  1.00  1.00  1.00  0.00
C           0.00  0.00  0.00  0.00  0.00  0.00  0.00
C
C       Output Operands:
C
C       C = 0.00  0.00  0.00  0.00  0.00  0.00  0.00
C           0.00  2.00  3.00  3.00  3.00  2.00  0.00
C           0.00  4.00  3.00  4.00  3.00  4.00  0.00
C           0.00  5.00  4.00  4.00  4.00  5.00  0.00
C           0.00  5.00  4.00  4.00  4.00  5.00  0.00
C           0.00  4.00  3.00  4.00  3.00  4.00  0.00
C           0.00  2.00  3.00  3.00  3.00  2.00  0.00
C           0.00  0.00  0.00  0.00  0.00  0.00  0.00
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C                       C.Vallens
C         2) Apr 88     L. Shanbeck     Simplified equation.
C
      SUBROUTINE GRAD2D(A, NRA, IRA, ICA, C, NRC, IRC, ICC, NRAA, NCAA)
C
      REAL A(1), C(1)
      INTEGER NRA,IRA,ICA,NRC,IRC,ICC,NRAA,NCAA
      INTEGER CBASE,J,I,CELM
      INTEGER IM1, IP1, NRAJM1, NRAJ, NRAJP1
      IF (NCAA.LE.0 .OR. NRAA.LE.0 .OR. NRAA.GT.NRA .OR.
     +    ICC.LE.0 .OR. IRC.LE.0 .OR. IRC.GT.NRC .OR.
     +    ICA.LE.0 .OR. IRA.LE.0 .OR. IRA.GT.NRA) GOTO 800
      CBASE = IRC + (ICC-1) * NRC
      DO 210 J = ICA-1, ICA+NCAA-2
        CELM = CBASE
        NRAJM1 = NRA*(J-1)
        NRAJ   = NRA*J
        NRAJP1 = NRA*(J+1)
        DO 200 I = IRA, NRAA-1+IRA
          IM1 = I - 1
          IP1 = I + 1
          C(CELM) = AMAX1(ABS(A(IM1 + NRAJM1) + A(IM1 + NRAJ) +
     *          A(IM1 + NRAJP1) - A(IP1 + NRAJM1) -
     *          A(IP1 + NRAJ) - A(IP1 + NRAJP1)),
     *                    ABS(A(IM1 + NRAJM1) + A(I + NRAJM1) +
     *          A(IP1 + NRAJM1) - A(IM1 + NRAJP1) -
     *          A(I + NRAJP1) - A(IP1 + NRAJP1)))
          CELM = CELM + 1
200     CONTINUE
        CBASE = CBASE + NRC
210   CONTINUE
800   RETURN
      END
