C*****  HAMM    Hamming Window Multiply           MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL HAMM (A,IA,C,IC,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine multiplies a vector by a Hamming window.
C
C            C(i) = A(i) * [0.54 - 0.46*COS((i-1)*(2*PI/N))]
C            for i=1,N.
C            PI = 3.14159...
C
C       Also see the descriptions for BLKMAN and HANN, two other
C       routines used for conditioning signals prior to
C       performing an FFT.
C
C
C  REFERENCE
C
C       R. B. Blackman and J. W. Tukey.  1958.  The measurement
C       of power spectra.  New York: Dover Publications.
C
C       L. R. Rabiner and B. Gold.  1975.  Theory and applica-
C       tion of digital signal processing.  Englewood Cliffs
C       NJ: Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL HAMM (A,1,C,1,5)
C
C       Input Operands:
C
C       A = 1.000
C           2.000
C           3.000
C           4.000
C           5.000
C
C       Output Operands:
C
C       C = 0.080
C           0.796
C           2.736
C           3.649
C           1.989
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE HAMM(A,IA,C,IC,N)
C
      INTEGER IA,IC,N,II,KK,M
      REAL A(1),C(1),PI
      IF (N.LE.0) GO TO 40
      PI = 8.0 * ATAN(1.0) / FLOAT(N)
      II = 1
      KK = 1
      DO 30 M=1,N
        C(KK) = A(II) * (0.54 - 0.46*COS(PI*FLOAT(M-1)))
        II = II+IA
        KK = KK+IC
30    CONTINUE
40    RETURN
      END
