C*****  HANN    Hanning Window Multiply           MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL HANN (A,IA,C,IC,N,IFLG)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C       IFLG    Integer input processing option flag:
C                   =0 for Unnormalized Hanning window.
C                      (Peak window value = 1.0)
C                   =1 for Normalized Hanning window.
C                      (Peak window value = SQRT (8.0/3.0)
C
C
C  DESCRIPTION
C
C       This routine multiplies a vector by a Hanning window.
C
C            C(i) = W * A(i) * [1.0 - COS((i-1)*(2*PI/N))]
C            for i=1,N
C
C       where,
C
C            W = 0.5 for IFLG=0,
C            W = SQRT (2.0/3.0)     for IFLG=1
C            PI = 3.14159...
C
C       Also see the descriptions for BLKMAN and HAMM, two other
C       routines used for conditioning signals prior to
C       performing an FFT.
C
C
C  REFERENCE
C
C       R. B. Blackman and J. W. Tukey.  1958.  The measurement
C       of power spectra.  New York: Dover Publications.
C
C       L. R. Rabiner and B. Gold.  1975.  Theory and applica-
C       tion of digital signal processing.  Englewood Cliffs
C       NJ: Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL HANN (A,1,C,1,5,0)
C
C       Input Operands:
C
C       A = 1.000
C           2.000
C           3.000
C           4.000
C           5.000
C
C       Output Operands:
C
C       C = 0.000
C           0.691
C           2.714
C           3.618
C           1.727
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE HANN(A,IA,C,IC,N,IFLG)
C
      INTEGER IA,IC,N,IFLG,II,KK,M
      REAL A(1),C(1),W,PI
      IF (N.LE.0 .OR. IFLG.LT.0 .OR. IFLG.GT.1) GO TO 40
      PI = 8.0 * ATAN(1.0) / FLOAT(N)
      II = 1
      KK = 1
      IF (IFLG.NE.0) GOTO 20
        W = 0.5
        GO TO 25
C
20      W = SQRT(2.0/3.0)
25    CONTINUE
      DO 30 M=1,N
        C(KK) = W * A(II) * (1.0-COS(PI*FLOAT(M-1)))
        II = II+IA
        KK = KK+IC
30    CONTINUE
40    RETURN
      END
