C*****  HIST    Histogram                         MATH ADVANTAGE REL 2.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL HIST (A,IA,C,N,NC,AMAX,AMIN)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       C       Real input/output vector.
C
C       N       Integer input element count of vector A.
C
C       NC      Integer input number of bins in C.
C
C       AMAX    Real input scalar, maximum histogram value.
C
C       AMIN    Real input scalar, minimum histogram value.
C
C
C  DESCRIPTION
C
C       This routine performs a histogram on a vector A and adds the
C       results to a histogram stored in vector C.  You specify the
C       maximum and minimum values of the range of interest and the
C       number of bins to use in C.  The width of each bin is
C       (AMAX - AMIN)/NC.
C
C       On input, vector C contains an initial histogram.  On output,
C       vector C has been updated to add the distribution of the element
C       values of vector A, that is, the number of elements of A that
C       fell in each bin.  Values below AMIN or above AMAX are counted
C       in the first and last bins respectively.
C
C            C(J(i)) = C(J(i)) + 1.0    for i=1,N
C
C       where,
C
C            J(i) = 1,   if A(i) < AMIN
C
C            J(i) = NC,  if A(i) >= AMAX
C
C            J(i) = 1+FIX[NC*(A(i)-AMIN)/(AMAX-AMIN)],
C                   if AMIN <= A(i) < AMAX
C
C
C  REFERENCE
C
C       R. K. Otnes and L. Enochson.  1978.  Applied time
C       series analysis, Vol. 1, Basic techniques.  New York:
C       Wiley & Sons.
C
C
C  EXAMPLE
C
C       CALL HIST (A,1,C,10,5,AMAX,AMIN)
C
C       Input Operands:
C
C       A =  13.000
C             5.000
C             8.500
C             3.000
C             4.000
C            -1.000
C             2.000
C             1.500
C             9.000
C             6.000
C
C       C =   1.000
C             0.000
C             2.000
C             1.000
C             0.000
C
C       AMAX =10.000
C
C       AMIN = 1.000
C
C       Output Operands:
C
C       C =   4.000
C             2.000
C             4.000
C             1.000
C             3.000
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C         2) Feb 88     L. Shanbeck     Changed example
C
      SUBROUTINE HIST(A,IA,C,N,NB,AMAX,AMIN)
C
      INTEGER IA,N,NB,II,M,JM
      REAL A(1),C(1),AMAX,AMIN
      IF (N.LE.0 .OR. NB.LE.0) GO TO 40
      II = 1
      DO 30 M=1,N
        IF (A(II).GE.AMIN) GOTO 10
          JM = 1
          GOTO 25
C
10        IF(A(II).LT.AMAX) GOTO 15
            JM = NB
            GOTO 25
C
15          JM = IFIX(FLOAT(NB)*(A(II)-AMIN)/(AMAX-AMIN))+1
C
25      C(JM) = C(JM) + 1.0
        II = II+IA
30    CONTINUE
40    RETURN
      END
