C*****  ICAMAX    Index of Complex Maximum Absolute Value   MATH ADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       IMAX = ICAMAX (N,CX,INCX)
C
C       where,
C
C       N       Integer input element count.
C
C       CX      Complex input vector.
C
C       INCX    Integer input stride for vector CX.
C               Must be positive.
C
C
C  DESCRIPTION
C
C       This function returns the first index of the largest absolute
C       value of the elements in vector CX.
C
C               ICAMAX = i
C       where CX(i) = maximum(abs(REAL(CX(j)))+abs(IMAG(CX(j))))  for j=1,N
C
C  REFERENCE
C
C       J.J. Dongarra and C.B. Moler, J.R. Bunch, G.W. Stewart.  1979.
C       LINPACK Users' Guide.  Appendix A: Basic Linear Algebra Subprograms.
C       SIAM
C
C
C  EXAMPLE
C
C       IMAX = ICAMAX (4,CX,1)
C
C       Input Operands:
C
C       CX =  (1.000,2.000)
C             (7.000,8.000)
C             (3.000,4.000)
C             (5.000,6.000)
C
C       Output Result:
C
C       IMAX = 2
C
C  HISTORY
C         1) Jan 88     L. Shanbeck     Original.
C
C
      INTEGER FUNCTION ICAMAX(N,CX,INCX)
C
      COMPLEX CX(1)
      REAL CMAX,SUMRI
      INTEGER N,INCX,II,M
C
      ICAMAX = 0
      IF (N.LE.0 .OR. INCX.LE.0) GO TO 40
      ICAMAX = 1
      IF (N.EQ.1) GO TO 40
      II = 1
      CMAX = ABS(REAL(CX(II))) + ABS(AIMAG(CX(II)))
      DO 10 M=2,N
        II = II + INCX
        SUMRI = ABS(REAL(CX(II))) + ABS(AIMAG(CX(II)))
        IF (SUMRI.LE.CMAX) GO TO 10
        ICAMAX = M
        CMAX = SUMRI
10    CONTINUE
40    RETURN
      END
