C*****  MINV    Minimum Element in Vector         MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL MINV (A,IA,C,LC,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       C       Real output scalar, minimum value detected.
C
C       LC      Integer output number of elements sampled to
C               reach minimum value.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine finds the minimum-value element in a vector
C       and stores it in C. Output value LC indicates the number
C       of tests that were performed to reach the first occurrence
C       of the minimum value.
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL MINV (A,1,C,LC,5)
C
C       Input Operands:
C
C       A = 2.000
C          -3.000
C           1.000
C          -2.000
C          -1.000
C
C       Output Operands:
C
C       C = -3.000
C
C       LC = 2
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE MINV(A,IA,C,LC,N)
C
      INTEGER IA,N,II,M,LC
      REAL A(1),C,TMP
      IF (N.LE.0) GO TO 12
      II = 1
      LC = 1
      TMP = A(1)
      DO 10 M=1,N
        IF (TMP.LE.A(II)) GOTO 7
          TMP = A(II)
          LC = M
7       II = II + IA
10    CONTINUE
      C = TMP
12    RETURN
      END
