C*****  MLINFT  Multi-Linear Regression         MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL MLINFT(A,WRK,WRK1,IWRK,C,D,M,N,IERR)
C
C       where,
C
C       A       Real input matrix containing tabulated independent
C               variables of size M by N.
C
C       WRK     Real work matrix of size M by M.
C
C       WRK1    Real work vector of length M.
C
C       IWRK    Integer work vector of length M.
C
C       C       Real output vector of length M containing tabulated
C               coefficients for the estimated regression line.
C
C       D       Real output scalar which denotes the standard
C               error of the estimate, computed as the root-mean-square
C               of the deviations about a fitted curve.
C
C       M       Integer input element count for the columns of matrix
C               A, also the number of dependent variables in the
C               regression plus 1.
C
C       N       Integer input element count for the rows of matrix A,
C               also the number of sets of data to be analyzed.
C
C       IERR    Integer output completion code:
C                  If IERR = 0, the routine terminated normally.
C                  If IERR > 0, the regression coefficient matrix
C                  cannot be solved.  The value of IERR is the index
C                  of the column where it aborted.
C
C
C  DESCRIPTION
C
C       This routine calculates the coefficients for a multi-linear
C       regression line with M-1 dependent variables.  A
C       standard error of estimate is calculated by the equation
C              D=SQRT((SUMDIFF**2)/N)
C            where:
C              SUMDIFF is the sum of the deviations about a fitted line.
C
C
C  REFERENCES
C
C       John E. Freund. 1973. Modern Elementary Statistics, Fourth
C       Edition. New Jersey: Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL MLINFT(A,WRK,WRK1,IWRK,C,D,3,8,IERR)
C
C       Input Operands:
C
C       A = 3.00  2.00  23800.0
C           2.00  1.00  19300.0
C           4.00  3.00  28800.0
C           2.00  1.00  19200.0
C           3.00  2.00  24700.0
C           2.00  2.00  19900.0
C           5.00  3.00  33400.0
C           4.00  2.00  27900.0
C
C       Output Operands:
C
C       C = 10191.667
C            4133.330
C             758.337
C
C       D =   292.795
C
C       IERR = 0
C
C
C  HISTORY
C         1) Jan 88       C. Ward         Original.
C
C         2) Jan 91       P. Crose        Changed order of type statements
C                                         for PC compiler problem.
C
       SUBROUTINE MLINFT(A,WRK,WRK1,IWRK,C,D,M,N,IERR)
C
      INTEGER IERR,I,J,K,M,N
      INTEGER IWRK(M)
      REAL A(N,M),WRK(M,M),C(M),WRK1(M),D,DIFF,SUMDIF
      REAL EPS,TINY,HUGE
C
      DATA EPS,TINY,HUGE /0.0,0.0,0.0/
      DIFF=0.0
      SUMDIF=0.0
      DO 100 I=1,M
         DO 101 J=1,M
           WRK(I,J) = 0.0
 101    CONTINUE
        WRK1(I)=0.0
        IWRK(I)=0
        C(I) = 0.0
 100  CONTINUE
      D=0.0
C
      IF (N .LE. 0 .OR. M .LE. 0) GOTO 999
C
C     Set machine dependent values, if necessary.
C
      IF (HUGE .EQ. 0.0) THEN
         CALL QTC045(EPS,TINY,HUGE)
      ENDIF
C
C     Set up the right hand side 1 dimensional matrix.
C
      WRK(1,1)=FLOAT(N)
      DO 41 I=1,N
         WRK1(1)=WRK1(1)+A(I,M)
 41   CONTINUE
C
C     Set up the first row and first column of the matrix to be solved.
C
      DO 55 I=2,M
         DO 44 J=1,N
             WRK(I,1)=WRK(I,1)+A(J,I-1)
             WRK(1,I)=WRK(I,1)
 44      CONTINUE
 55      CONTINUE
C
C     Fill in the rest of the matrix.
C
      DO 66 I=2,M
         DO 77 J=2,M
            DO 88 K=1,N
               WRK(I,J)=WRK(I,J)+A(K,I-1)*A(K,J-1)
 88         CONTINUE
 77      CONTINUE
         DO 98 K=1,N
            WRK1(I)=WRK1(I)+A(K,I-1)*A(K,M)
 98      CONTINUE
 66   CONTINUE
C
C     Call factor and solve routine to uotput the coefficients of the
C     final regression line.
C
      CALL RMFUFS(WRK,M,M,WRK1,M,1,TINY,IWRK,C,M,IERR)
C
C     Calculate the standard error for the deviations of the data
C     from the fitted line.
C
       DO 24 I=1,N
          SUMDIF=A(I,M)-C(1)
          DO 25 J=2,M
             SUMDIF=SUMDIF-(C(J)*A(I,J-1))
 25       CONTINUE
          DIFF = DIFF + (SUMDIF*SUMDIF)
 24    CONTINUE
C
       D=SQRT(DIFF/FLOAT(N))
C
 999  CONTINUE
      RETURN
      END
