C****** MOMNT3   SECOND AND THIRD MOMENTS ABOUT MEAN       MTADV EXT  REL 1.0
C
C      ** COPYRIGHT 1988  QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C        CALL MOMNT3 (A,IA,AMEAN,AMOM2,AMOM3,N)
C
C        where,
C
C        A        Real input vector.
C
C        IA       Integer input stride for A.
C
C        AMEAN    Real output mean of selected elements of A.
C
C        AMOM2    Real output second moment about the mean.
C
C        AMOM3    Real output third moment about the mean.
C
C        N        Integer input number of elements in A.
C
C  DESCRIPTION
C
C        This routine will find the third and second moments about
C        the mean.  These moments are found from the moments about the
C        origin.  In general, the  kth moment of a vector A about some
C        scaler X is defined as:
C
C                           N
C                          SUM { ( A(i) - X )**k }/N
C                          i=1
C
C        Note that if N is less than or equal to zero, this routine exits
C        immediately.
C
C  REFERENCE
C
C        W. H. Beyer, 1966, CRC Handbook of Tables for Probability and
C        Statistics (Chemical Rubber Co., Cleveland, Ohio) page 3.
C
C  EXAMPLE
C
C        CALL MOMNT3 (A, 1, AMEAN, AMOM2, AMOM3, 5)
C
C        Input Operands:
C
C              A = (2.000)
C                  (3.000)
C                  (3.000)
C                  (6.000)
C                  (4.000)
C
C        Output Operands:
C
C              AMEAN  =  3.59999990E+00
C
C              AMOM2  =  1.84000004E+00
C
C              AMOM3  =  1.87199998E+00
C
C
C  SUBPROGRAMS:
C
C        INTRINSICS:  FLOAT
C
C  HISTORY
C        (1) MAY 88           T.G. Mattson           Original
C
C-----------------------------------------------------------------------
C
      SUBROUTINE MOMNT3 (A, IA, AMEAN, AMOM2, AMOM3, N)
C
      REAL    A(*), AMEAN, AMOM2, AMOM3
      INTEGER IA, N, JA, J
C
      DOUBLE PRECISION DNRCIP, SUM1, SUM2, SUM3,
     &               AJ, AJSQ, ANU1, ANU2, ANU3
C
C-----------------------------------------------------------------------
C
      IF (N .LE. 0) GO TO 800
C
      DNRCIP = 1.0D0 / FLOAT( N )
C
      SUM1 = 0.0D0
      SUM2 = 0.0D0
      SUM3 = 0.0D0
      JA   = 1
      DO 110 J = 1, N
         AJ   = A(JA)
         AJSQ = AJ * AJ
         SUM1 = SUM1 + AJ
         SUM2 = SUM2 + AJSQ
         SUM3 = SUM3 + AJSQ * AJ
         JA   = JA + IA
  110 CONTINUE
C
C  Compute the moments about the origin
C
      ANU1 = SUM1 * DNRCIP
      ANU2 = SUM2 * DNRCIP
      ANU3 = SUM3 * DNRCIP
C
C  Compute moments about the mean
C
      AMEAN = ANU1
      AMOM2  = ANU2 - ANU1 * ANU1
      AMOM3  = ANU3 - 3.0D0 * ANU1 * ANU2 + 2.0D0 * ANU1 * ANU1 * ANU1
C
  800 CONTINUE
      RETURN
      END
