C*****  MVESSQ   Mean of Vector Element Signed Squares  MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL MVESSQ (A,IA,C,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       C       Real output scalar.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine comutes the mean of the signed squares
C       of the elements of the vector A.  The result is
C       stored in scalar C.
C
C          C = SUM( A(i) * ABS(A(i)) ) / N   for i = 1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL MVESSQ (A,1,C,5)
C
C       Input Operands:
C
C       A =  0.000
C           -1.000
C            0.000
C            1.000
C            2.000
C
C
C       Output Operands:
C
C       C = 0.800
C
C
C  HISTORY
C         1) Jul 86     D. Benua        Original.
C
      SUBROUTINE MVESSQ(A,IA,C,N)
C
      INTEGER IA,N,M,II
      REAL A(1),C
      IF (N.LE.0) GO TO 12
      II = 1
      C = 0.0
      DO 10 M=1,N
          C = C + ( A(II) * ABS(A(II)) )
          II = II + IA
10    CONTINUE
      C = C / N
12    RETURN
      END
