C*****  POLAR   Rectangular to Polar Conversion   MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL POLAR (A,IA,C,IC,N)
C
C       where,
C
C       A       Complex input vector.
C
C       IA      Integer input stride for vector A.
C
C       C       Complex output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine converts elements of a complex vector
C       from rectangular to polar form and stores the result
C       in complex vector C.
C
C            real(C(i)) = SQRT(real(A(i))**2 + imag(A(i))**2)
C            imag(C(i)) = ATAN2(imag(A(i)), real(A(i)))    for i=1,N
C
C
C  REFERENCE
C
C       J. H. Matthews.  1982.  Basic complex variables for
C       mathematics and engineering.  New York: Allyn and
C       Bacon.
C
C
C  EXAMPLE
C
C       CALL POLAR (A,2,C,2,2)
C
C       Input Operands:
C
C       A = (1.000, 1.000)
C           (2.000,-2.000)
C
C       Output Operands:
C
C       C = (1.414, 0.785)
C           (2.828,-0.785)
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE POLAR(A,IA,C,IC,N)
C
      INTEGER IA,IC,N,II,KK,M
      REAL A(1),C(1),MAG
      IF (N.LE.0) GO TO 12
      II = 1
      KK = 1
      DO 10 M=1,N
        MAG = SQRT(A(II)*A(II) + A(II+1)*A(II+1))
        IF (MAG .EQ. 0.0) GOTO 4
          C(KK+1) = ATAN2(A(II+1),A(II))
          GOTO 6
C       (ELSE BOTH ARGUMENTS ZERO)
4         C(KK+1) = 0.0
C       (ENDIF)
6       C(KK) = MAG
        II = II+IA
        KK = KK+IC
10    CONTINUE
12    RETURN
      END
