C***** POLYFT Polynomial Least-Squares Curve Fit  MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1987 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL POLYFT(A,IA,B,IB,C,IC,N,M,D,WRK,WRK1,IWRK,ZTOL,CHISQ,IERR)
C
C       where,
C
C       A       Real input vector of length N.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input vector of length N.
C
C       IB      Integer input stride for vector B.
C
C       C       Real input vector of length N.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count for A, B, and C.
C
C       M       Integer input order of polynomial to be fit to A,B
C               input data points.
C
C       D       Real output vector of coefficients, length M + 1.
C
C       WRK     Real work matrix of dimension (M+1) by (M+1)
C
C       WRK1    Real work vector of length 2*M + 1 or N, whichever is
C               larger.
C
C       IWRK    Integer work vector of length M + 1.
C
C       ZTOL    Real input scalar, diagonal element zero tolerance.
C
C       CHISQ   Real output scalar, sum of weighted squared errors.
C
C       IERR    Integer output completion code:
C                   If IERR=0, the routine terminated normally
C                   If IERR>0, the routine aborted because the solution
C                   of the least squares equations failed. The value
C                   of IERR is the index of the column where it aborted.
C
C  DESCRIPTION
C
C       This routine performs a least-squares polynomial fit to real
C       input data.  The routine attempts to describe the N input
C       data pairs contained in the vectors A and B by an equation
C       of the form
C
C          Y = D(1)*A(i)**M + D(2)*A(i)**(M-1) + ... + D(M+1)
C
C       where the D() values are chosen to minimize the squared errors
C       given by the summation
C
C         CHISQ = SUM[C(i)*((B(i)-D(1)*A(i)**M-D(2)*A(i)**(M-1)-...
C                   -D(M+1))**2)]
C
C       for i = 1,N.
C
C       The solution is derived by means of a standard least-squares
C       derivation, which results at an intermediate step in a
C       matrix equation of the form Ax = b, which is solved to
C       yield the coefficients D().  If this solution fails because
C       a diagonal element was less than or equal to ZTOL (implying
C       that the matrix is singular), the IERR flag is set to the
C       index of the column where it aborted.
C
C
C  REFERENCES
C
C       John E. Freund. 1973. Modern Elementary Statistics, Fourth
C       Edition. New Jersey: Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL POLYFT(A,1,B,1,C,1,8,2,D,WRK,WRK1,IWRK,ZTOL,CHISQ,IERR)
C
C       Input Operands:
C
C       A =   1.000     B = 0.000     C = 1.000
C             2.000         3.000         1.000
C             3.000         8.000         1.000
C             4.000        15.000         1.000
C             5.000        24.000         1.000
C             6.000        35.000         1.000
C             7.000        48.000         1.000
C             8.000        63.000         1.000
C
C       Output Operands:
C
C       D =   1.000
C             0.000
C            -1.000
C
C       CHISQ = 0.0
C
C       IERR = 0
C
C
C  HISTORY
C         1)  7/22/87  L. A. Westerman    Original
C         2)  Oct 90   R. Coleman         Problelm fix
C
      SUBROUTINE POLYFT(A,IA,B,IB,C,IC,N,M,D,WRK,WRK1,IWRK,ZTOL,CHISQ,
     + IERR)
C
C     INPUT VARIABLES
C
      REAL    A(1),B(1),C(1),ZTOL
      INTEGER IA,IB,IC,N,M
C
C     OUTPUT VARIABLES
C
      REAL    D(1),CHISQ
      INTEGER IERR
C
C     WORK VARIABLES
C
      REAL    WRK(M+1,M+1),WRK1(1)
      INTEGER IWRK(1)
C
C     LOCAL VARIABLES
C
      INTEGER I,J,LSC
      REAL    X,Y,W,SC,RSC
C
C     Test the input variables
C
      IF (N.LE.0 .OR. M.LT.0) GOTO 40
C
C     Calculate scaling factor
C
      CALL MAXMGV(A,IA,SC,LSC,N)
      IF (SC .EQ. 0.0) SC = 1.0
      RSC = 1.0 / SC
C
C     Calculate the appropriate matrix and vector
C
      CALL VCLR(D,1,M+1)
      CALL VCLR(WRK,1,(M+1)*(M+1))
      DO 30 I=1,N
        X = A(1+IA*(I-1)) * RSC
        Y = B(1+IB*(I-1))
        W = C(1+IC*(I-1))
C
C       Fill the vector WRK1 with powers of X
C
        WRK1(M+M+1) = 1.0
        DO 10 J = M+M,1,-1
           WRK1(J) = WRK1(J+1) * X
10      CONTINUE
C
C       Multiply the powers by the weighting factor
C
        CALL VSMUL(WRK1,1,W,WRK1,1,M+M+1)
        CALL VSMA(WRK1(M+1),1,Y,D,1,D,1,M+1)
        DO 20 J=1,M+1
          CALL VADD(WRK1(J),1,WRK(1,J),1,WRK(1,J),1,M+1)
20      CONTINUE
30    CONTINUE
C
C     Solve the equation WRK * WRK1 = D for the vector WRK1
C
      CALL RMFUFS(WRK,M+1,M+1,D,M+1,1,ZTOL,IWRK,WRK1,M+1,IERR)
C
C     Scale and move the results to the output vector
C
      SC = 1.0
      DO 35 J = M+1,1,-1
         D(J) = WRK1(J) * SC
         SC   = SC * RSC
35    CONTINUE
C
C     Calculate the weighted sum of the squared errors
C
      CALL VPOLY(D,1,A,IA,WRK1,1,N,M)
      CALL VSUB(B,IB,WRK1,1,WRK1,1,N)
      CALL VSQ(WRK1,1,WRK1,1,N)
      CALL VMUL(WRK1,1,C,IC,WRK1,1,N)
      CALL SVE(WRK1,1,CHISQ,N)
40    RETURN
      END
