C*****  QTC017  MATH ADVANTAGE Private Subroutine RYMXL
C   ***** QTC017(=RYMXL) = REAL Y = S(Y - AX), A LOWER TRIANGULAR
C
      SUBROUTINE QTC017( S, Y, INCY, X, INCX, A, L, N)
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C      REAL    A     (1)      ! INPUT N BY N LOWER TRIANGULAR SUBMATRIX
C      INTEGER I              ! ROW INDEX
C      INTEGER IA             ! I LOOP POINTER FOR A
C      INTEGER INCX           ! ADDRESS INCREMENT FOR VECTOR X
C      INTEGER INCY           ! ADDRESS INCREMENT FOR VECTOR Y
C      INTEGER IX             ! I LOOP POINTER FOR X
C      INTEGER J              ! COLUMN INDEX
C      INTEGER JA             ! J LOOP POINTER FOR A
C      INTEGER JX             ! J LOOP POINTER FOR X
C      INTEGER JY             ! J LOOP POINTER FOR Y
C      INTEGER L              ! NUMBER OF ROWS IN THE FULL MATRIX A
C      INTEGER LP1            ! L + 1
C      INTEGER N              ! ORDER OF THE SUBMATRIX A
C      REAL    S              ! INPUT SCALE FACTOR
C      REAL    SUM            ! INNER PRODUCT ACCUMULATOR
C      REAL    X     (1)      ! INPUT VECTOR OF LENGTH N
C      REAL    Y     (1)      ! INPUT/OUTPUT VECTOR OF LENGTH N
       INTEGER I,IA,INCX,INCY,IX,J,JA,JX,JY,L,LP1,N
       REAL    A(1),S,SUM,X(1),Y(1)
C
C   *******************************************************************
C
      LP1 = L + 1
      JA  = 1
      JX  = 1
      JY  = 1
      DO 120 J = 1, N
         IA  = JA
         IX  = JX
         SUM = Y(JY)
         DO 110 I = J, N
            SUM = SUM - X(IX) * A(IA)
            IA  = IA + 1
            IX  = IX + INCX
  110    CONTINUE
         Y(JY) = S * SUM
         JA = JA + LP1
         JX = JX + INCX
         JY = JY + INCY
  120 CONTINUE
      RETURN
      END
