C*****  QTC019  MATH ADVANTAGE Private Subroutine XRFFT
C   ***** EXPANDED REAL-TO-COMPLEX FFT (IN PLACE) *****
C  THIS SUBROUTINE REPLACES THE REAL VECTOR  C(K), (K=1,2,....,N),
C  WITH ITS FINITE DISCRETE FOURIER TRANSFORM. THE DC TERM IS
C  RETURNED IN LOCATION C(1).  THEREAFTER, THE
C  JTH HARMONIC IS RETURNED AS A COMPLEX NUMBER STORED AS
C  C(2*J+1) + I C(2*J+2).  NOTE THAT THE N/2 HARMONIC IS RETURNED
C  IN C(2).
C  A REAL-VALUED, RADIX 8 ALGORITHM IS USED
C  WITH IN-PLACE REORDERING AND THE TRIG FUNCTIONS ARE COMPUTED AS
C  NEEDED.
C
      SUBROUTINE QTC019(C,N,DI,F)
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
      INTEGER N,DI,F,NFFT
      REAL C(1)
      INTEGER M,I,NN,INT,N8POW,IT,NEWI
C      DATA PII,P7,P7TWO /3.14159265,0.707106781,1.41421356/
C      DATA C22,S22,PI2 /0.923879532,0.382683432,6.28318531/
      IF (N.LE.1) GOTO 490
      NFFT = 1
      DO 10 I=1,15
        M = I
        NFFT = NFFT+NFFT
        IF (NFFT.EQ.N) GO TO 20
        IF (NFFT.GT.N) GOTO 490
10    CONTINUE
20    CONTINUE
      N8POW = M/3
C  DECIDE WHICH DIRECTION FFT IS:
      IF (F.EQ.-1) GOTO 400
C
C  DO A RADIX 2 OR RADIX 4 ITERATION FIRST IF ONE IS REQUIRED
C
      IF (M-N8POW*3-1) 50, 40, 30
30    NN = 4
      INT = NFFT/NN * DI
      CALL QTC012(INT/DI, C(1), C(INT+1), C(2*INT+1), C(3*INT+1), DI)
      GO TO 60
  40  NN = 2
      INT = NFFT/NN * DI
      CALL QTC009(INT/DI, C(1), C(INT+1), DI)
      GO TO 60
  50  NN = 1
C
C  PERFORM RADIX 8 ITERATIONS
C
  60  IF (N8POW) 90, 90, 70
  70  DO 80 IT=1,N8POW
        NN = NN*8
        INT = NFFT/NN * DI
        CALL QTC015(INT/DI, NN, C(1), C(INT+1), C(2*INT+1), C(3*INT+1),
     *      C(4*INT+1), C(5*INT+1), C(6*INT+1), C(7*INT+1), C(1),
     *      C(INT+1), C(2*INT+1), C(3*INT+1), C(4*INT+1), C(5*INT+1),
     *      C(6*INT+1), C(7*INT+1), DI)
  80  CONTINUE
C
C  PERFORM IN-PLACE REORDERING
C
  90  CALL QTC007(M,C,DI)
      CALL QTC008(M,C,DI)
      IF (NFFT.LT.4) GOTO 105
      DO 100 I=4,NFFT,2
        NEWI = (I-1) * DI + 1
        C(NEWI) = -C(NEWI)
 100  CONTINUE
105   DO 120 I=1,NFFT
        NEWI = (I-1) * DI + 1
        C(NEWI) = C(NEWI)+C(NEWI)
120   CONTINUE
      GOTO 490
C
C **** START OF INVERSE FFT STEPS ****
C
400   IF (NFFT.LT.4) GOTO 445
      DO 440 I=4,NFFT,2
        NEWI = (I-1) * DI + 1
        C(NEWI) = -C(NEWI)
440   CONTINUE
C
C  REORDER THE INPUT FOURIER COEFFICIENTS
C
445   CALL QTC008(M,C,DI)
      CALL QTC007(M,C,DI)
C
      IF (N8POW.EQ.0) GO TO 460
C
C  PERFORM THE RADIX 8 ITERATIONS
C
      NN = NFFT
      DO 450 IT=1,N8POW
        INT = NFFT/NN * DI
        CALL QTC014(INT/DI, NN, C, C(INT+1), C(2*INT+1), C(3*INT+1),
     *      C(4*INT+1), C(5*INT+1), C(6*INT+1), C(7*INT+1), C(1),
     *      C(INT+1), C(2*INT+1), C(3*INT+1), C(4*INT+1), C(5*INT+1),
     *      C(6*INT+1), C(7*INT+1), DI)
        NN = NN/8
450   CONTINUE
C
C  DO A RADIX 2 OR RADIX 4 ITERATION IF ONE IS REQUIRED
C
460   IF (M-N8POW*3-1) 490, 480, 470
470   INT = NFFT/4 * DI
      CALL QTC011(INT/DI, C(1), C(INT+1), C(2*INT+1), C(3*INT+1), DI)
      GO TO 490
480   INT = NFFT/2 * DI
      CALL QTC009(INT/DI, C(1), C(INT+1), DI)
490   RETURN
      END
