C*****  QTC046  MATH ADVANTAGE Private Subroutine    CFFTBL
C   ***** EXPANDED COMPLEX-TO-COMPLEX FFT WITH TABLE ******
C ---- USES DI AS INCREMENT (NORMALLY 2),
C       REAL ELEMENT IS AT (IA-1)*DI/2+1, IMAGINARY AT (IA-2)*DI/2+2
      SUBROUTINE QTC046(C,N,DI,IFLG,RTBL,NT)
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
      INTEGER N,DI,IFLG,NFFT
      REAL C(1)
      REAL R,FI
      INTEGER M,IA,N2POW,NTHPO,N8POW
      INTEGER ID(15),L1,L2,L3,L4,L5,L6,L7,L8,L9,L10,L11,L12,L13,L14,L15
      INTEGER NXTLT,IPASS,LENGT,IB,IJ,IJ2,JI,JI2
      INTEGER J1,J2,J3,J4,J5,J6,J7,J8,J9,J10,J11,J12,J13,J14
      INTEGER NEWI, NSPAN, DIOV2, IINC
      EQUIVALENCE (L15,ID(1)),(L14,ID(2)),(L13,ID(3)),(L12,ID(4)),
     1      (L11,ID(5)),(L10,ID(6)),(L9,ID(7)),(L8,ID(8)),(L7,ID(9)),
     2      (L6,ID(10)),(L5,ID(11)),(L4,ID(12)),(L3,ID(13)),
     3      (L2,ID(14)),(L1,ID(15))
C      DATA PI2,P7 /6.28318531,0.707106781/
      IF (N.LE.1) GOTO 170
      NFFT = 1
      DO 10 IA=1,15
        M = IA
        NFFT = NFFT+NFFT
        IF (NFFT.EQ.N) GO TO 20
        IF (NFFT.GT.N) GOTO 170
10    CONTINUE
20    N2POW = M
      NTHPO = NFFT
      DIOV2 = DI/2
      IF (IFLG.EQ.-1) GOTO 40
        DO 30 IA=2,NTHPO+NTHPO,2
          NEWI = (IA-2)*DIOV2+2
          C(NEWI) = -C(NEWI)
30      CONTINUE
40    N8POW = N2POW/3
      IF (N8POW.EQ.0) GOTO 60
C
C     RADIX 8 PASSES, IF ANY.
C
      IINC = NT / N
      DO 50 IPASS=1,N8POW
        NXTLT = 2**(N2POW-3*IPASS)
        NSPAN = NXTLT * DI
        LENGT = 8*NXTLT
        CALL QTC048(NXTLT,NTHPO,LENGT,C(1),C(NSPAN+1),C(2*NSPAN+1),
     1       C(3*NSPAN+1),C(4*NSPAN+1),C(5*NSPAN+1),C(6*NSPAN+1),
     2       C(7*NSPAN+1),DI,RTBL,IINC,NT)
        IINC = 8*IINC
50    CONTINUE
C
C     IS THERE A FOUR FACTOR LEFT?
C
60    IF (N2POW-3*N8POW-1) 90,70,80
C
C     GO THROUGH THE BASE 2 ITERATION
C
70    CALL QTC010(NTHPO,C(1),C(DI+1),DI)
      GOTO 90
C
C     GO THROUGH THE BASE 4 ITERATION
C
80    CALL QTC013(NTHPO,C(1),C(DI+1),C(DI+DI+1),C(DI+DI+DI+1),DI)
C
90    DO 110 IB=1,15
        ID(IB) = 1
        IF (IB-N2POW) 100, 100, 110
100     ID(IB) = 2**(N2POW+1-IB)
110   CONTINUE
C
C     BIT-REVERSE STEPS:
C
      IJ = 1
      DO 130 J1=1,L1
      DO 130 J2=J1,L2,L1
      DO 130 J3=J2,L3,L2
      DO 130 J4=J3,L4,L3
      DO 130 J5=J4,L5,L4
      DO 130 J6=J5,L6,L5
      DO 130 J7=J6,L7,L6
      DO 130 J8=J7,L8,L7
      DO 130 J9=J8,L9,L8
      DO 130 J10=J9,L10,L9
      DO 130 J11=J10,L11,L10
      DO 130 J12=J11,L12,L11
      DO 130 J13=J12,L13,L12
      DO 130 J14=J13,L14,L13
      DO 130 JI=J14,L15,L14
        IF (IJ-JI) 120,130,130
120       IJ2 = (IJ-1) * DI + 2
          JI2 = (JI-1) * DI + 2
          R = C(IJ2-1)
          FI = C(IJ2)
          C(IJ2-1) = C(JI2-1)
          C(IJ2) = C(JI2)
          C(JI2-1) = R
          C(JI2) = FI
130     IJ = IJ + 1
C
      IF (IFLG.EQ.-1) GOTO 170
        DO 140 IA=2,NTHPO+NTHPO,2
          NEWI = (IA-2)*DIOV2+2
          C(NEWI) = -C(NEWI)
140     CONTINUE
170   RETURN
      END
