C*****  QTC048  MATH ADVANTAGE Private Subroutine R8TBL
C   ***** RADIX 8 ITERATION SUBROUTINE            *****
      SUBROUTINE QTC048(NXTLT,NTHPO,LENGT,CR0,CR1,CR2,CR3,CR4,CR5,
     +                 CR6,CR7,DI,RTBL,IINC,NT)
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
      INTEGER NTHPO,NXTLT,LENGT,IB,IC,KR,KI,DI,IINC,NT
      REAL CR0(1),CR1(1),CR2(1),CR3(1),CR4(1),CR5(1),
     +     CR6(1),CR7(1),RTBL(1)
      REAL P7,TR,TI
      REAL C1,C2,C3,C4,C5,C6,C7
      REAL S1,S2,S3,S4,S5,S6,S7
      REAL AR0,AR1,AR2,AR3,AR4,AR5,AR6,AR7
      REAL AI0,AI1,AI2,AI3,AI4,AI5,AI6,AI7
      REAL BR0,BR1,BR2,BR3,BR4,BR5,BR6,BR7
      REAL BI0,BI1,BI2,BI3,BI4,BI5,BI6,BI7
      INTEGER IC0,ICC,IS0,ISS,ISTR
C
      IF (NXTLT.LE.0) GOTO 40
      P7 =  SQRT(0.5)
      IC0 = 1 + (NT / 8)
      IS0 = 1 + (NT * 7 / 8)
      ISTR = IINC
      DO 30 IB=1,NXTLT
        IF (NTHPO.LT.IB) GOTO 40
        DO 20 IC=IB,NTHPO,LENGT
          KI = (IC-1) * DI + 2
          KR = KI - 1
          AR0 = CR0(KR) + CR4(KR)
          AR1 = CR1(KR) + CR5(KR)
          AR2 = CR2(KR) + CR6(KR)
          AR3 = CR3(KR) + CR7(KR)
          AR4 = CR0(KR) - CR4(KR)
          AR5 = CR1(KR) - CR5(KR)
          AR6 = CR2(KR) - CR6(KR)
          AR7 = CR3(KR) - CR7(KR)
          AI0 = CR0(KI) + CR4(KI)
          AI1 = CR1(KI) + CR5(KI)
          AI2 = CR2(KI) + CR6(KI)
          AI3 = CR3(KI) + CR7(KI)
          AI4 = CR0(KI) - CR4(KI)
          AI5 = CR1(KI) - CR5(KI)
          AI6 = CR2(KI) - CR6(KI)
          AI7 = CR3(KI) - CR7(KI)
          BR0 = AR0 + AR2
          BR1 = AR1 + AR3
          BR2 = AR0 - AR2
          BR3 = AR1 - AR3
          BR4 = AR4 - AI6
          BR5 = AR5 - AI7
          BR6 = AR4 + AI6
          BR7 = AR5 + AI7
          BI0 = AI0 + AI2
          BI1 = AI1 + AI3
          BI2 = AI0 - AI2
          BI3 = AI1 - AI3
          BI4 = AI4 + AR6
          BI5 = AI5 + AR7
          BI6 = AI4 - AR6
          BI7 = AI5 - AR7
          CR0(KR) = BR0 + BR1
          CR0(KI) = BI0 + BI1
          IF (IB.LE.1) GOTO 10
            CR1(KR) = C4 * (BR0 - BR1) + S4 * (BI0 - BI1)
            CR1(KI) = C4 * (BI0 - BI1) - S4 * (BR0 - BR1)
            CR2(KR) = C2 * (BR2 - BI3) + S2 * (BI2 + BR3)
            CR2(KI) = C2 * (BI2 + BR3) - S2 * (BR2 - BI3)
            CR3(KR) = C6 * (BR2 + BI3) + S6 * (BI2 - BR3)
            CR3(KI) = C6 * (BI2 - BR3) - S6 * (BR2 + BI3)
            TR = P7 * (BR5 - BI5)
            TI = P7 * (BR5 + BI5)
            CR4(KR) = C1 * (BR4 + TR) + S1 * (BI4 + TI)
            CR4(KI) = C1 * (BI4 + TI) - S1 * (BR4 + TR)
            CR5(KR) = C5 * (BR4 - TR) + S5 * (BI4 - TI)
            CR5(KI) = C5 * (BI4 - TI) - S5 * (BR4 - TR)
            TR = -P7 * (BR7 + BI7)
            TI = P7 * (BR7 - BI7)
            CR6(KR) = C3 * (BR6 + TR) + S3 * (BI6 + TI)
            CR6(KI) = C3 * (BI6 + TI) - S3 * (BR6 + TR)
            CR7(KR) = C7 * (BR6 - TR) + S7 * (BI6 - TI)
            CR7(KI) = C7 * (BI6 - TI) - S7 * (BR6 - TR)
            GOTO 20
C       HERE WHEN IB = 1:
10          CR1(KR) = BR0 - BR1
            CR1(KI) = BI0 - BI1
            CR2(KR) = BR2 - BI3
            CR2(KI) = BI2 + BR3
            CR3(KR) = BR2 + BI3
            CR3(KI) = BI2 - BR3
            TR = P7 * (BR5 - BI5)
            TI = P7 * (BR5 + BI5)
            CR4(KR) = BR4 + TR
            CR4(KI) = BI4 + TI
            CR5(KR) = BR4 - TR
            CR5(KI) = BI4 - TI
            TR = -P7 * (BR7 + BI7)
            TI = P7 * (BR7 - BI7)
            CR6(KR) = BR6 + TR
            CR6(KI) = BI6 + TI
            CR7(KR) = BR6 - TR
            CR7(KI) = BI6 - TI
C         ENDIF
20      CONTINUE
        IF (IB.EQ.NXTLT) GOTO 30
           ICC = IC0 + ISTR
           C1 = RTBL(ICC)
           ICC = ICC + ISTR
           C2 = RTBL(ICC)
           ICC = ICC + ISTR
           C3 = RTBL(ICC)
           ICC = ICC + ISTR
           C4 = RTBL(ICC)
           ICC = ICC + ISTR
           C5 = RTBL(ICC)
           ICC = ICC + ISTR
           C6 = RTBL(ICC)
           ICC = ICC + ISTR
           C7 = RTBL(ICC)
           ISS = IS0 - ISTR
           S1 = RTBL(ISS)
           ISS = ISS - ISTR
           S2 = RTBL(ISS)
           ISS = ISS - ISTR
           S3 = RTBL(ISS)
           ISS = ISS - ISTR
           S4 = RTBL(ISS)
           ISS = ISS - ISTR
           S5 = RTBL(ISS)
           ISS = ISS - ISTR
           S6 = RTBL(ISS)
           ISS = ISS - ISTR
           S7 = RTBL(ISS)
           ISTR = ISTR + IINC
30    CONTINUE
40    RETURN
      END
