C*****  QTC049  MATH ADVANTAGE Private Subroutine   RSCRX
C   ***** REAL/COMPLEX SCRAMBLE UTILITY FOR RFFTX   *****
C
      SUBROUTINE QTC049 (A, N, IDIR, RTAB, NT)
C
C    ** COPYRIGHT 1987-1988 QUANTITATIVE TECHNOLOGY CORPORATION **
C
      REAL A(1), RTAB(1)
      REAL ARL, AIL, ARH, AIH, APBR, AMBR, APBI, AMBI
      REAL TRPBI, TIMBR, TIPBI, TRMBR, WIM, WRE
      INTEGER N, IDIR, NT, IS0, IC0, IWD, IPRL, IPIL, IPIH, IPRH
C
      IPRL = 1
      IPIL = 2
      IC0 = 1 + (NT / 8)
      IS0 = 1 + (NT * 7 / 8)
      IWD = NT / N
C
C----------------------------
C  First Pair, special case
C----------------------------
C
      ARL = A(IPRL)
      AIL = A(IPIL)
C
      IF (IDIR .GE. 0) THEN
        A(IPRL) = 2.0 * (ARL + AIL)
        A(IPIL) = 2.0 * (ARL - AIL)
        DSGN    = 1.0
      ELSE
        A(IPRL) = ARL + AIL
        A(IPIL) = ARL - AIL
        DSGN    = -1.0
      ENDIF
C
C-------------
C  Main Loop
C-------------
C
      IPRH = N + 1
      DO 10 I=1,N/4
C
        IPRL = IPIL + 1
        IPIL = IPRL + 1
        ARL = A(IPRL)
        AIL = A(IPIL)
C
        IPIH = IPRH - 1
        IPRH = IPIH - 1
        ARH = A(IPRH)
        AIH = A(IPIH)
C
        APBR = ARL + ARH
        AMBR = ARL - ARH
        APBI = AIL + AIH
        AMBI = AIL - AIH
C
        IC0 = IC0 + IWD
        IS0 = IS0 - IWD
        CF = RTAB(IC0) * DSGN
        SF = RTAB(IS0)
C
        TRPBI = CF * APBI
        TIMBR = SF * AMBR
        TIPBI = SF * APBI
        TRMBR = CF * AMBR
C
        WRE = TRPBI + TIMBR
        WIM = TIPBI - TRMBR
C
        A(IPRL) = APBR + WRE
        A(IPIL) = WIM + AMBI
C
        A(IPRH) = APBR - WRE
        A(IPIH) = WIM - AMBI
C
10    CONTINUE
C
      RETURN
      END
